/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.RubyMotion;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class RubyMotionCommandLauncher {
    private final AbstractBuild build;
    private final Launcher launcher;
    private final BuildListener listener;

    public RubyMotionCommandLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
    }

    public String getProjectWorkspace() {
        return this.build.getProject().getWorkspace().toString();
    }

    public FilePath getWorkspaceFilePath(String fileName) {
        return this.build.getWorkspace().child(fileName);
    }

    public boolean exec(String command) {
        command = "bash -c \"" + command + "\"";
        try {
            int r = this.launcher.launch().cmdAsSingleString(command).envs((Map)this.build.getEnvironment((TaskListener)this.listener)).stdout((OutputStream)this.listener.getLogger()).pwd(this.getProjectWorkspace()).join();
            return r == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.listener.getLogger().println("IOException !");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.listener.getLogger().println("InterruptedException !");
            return false;
        }
    }

    public boolean exec(String command, OutputStream outputStream) {
        command = "bash -c \"" + command + "\"";
        try {
            int r = this.launcher.launch().cmdAsSingleString(command).envs((Map)this.build.getEnvironment((TaskListener)this.listener)).stdout(outputStream).stderr((OutputStream)this.listener.getLogger()).pwd(this.getProjectWorkspace()).join();
            return r == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.listener.getLogger().println("IOException !");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.listener.getLogger().println("InterruptedException !");
            return false;
        }
    }

    public void printLog(String string) {
        this.listener.getLogger().println(string);
    }
}

