// CHECKSTYLE:OFF

package org.jenkinsci.plugins.xunit.service;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code XUnitValidationService.invalidInput}: {@code The file

     * ''{0}'' is an invalid file.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The file ''{0}'' is an invalid file.}
     */
    public static String XUnitValidationService_invalidInput(Object arg0) {
        return holder.format("XUnitValidationService.invalidInput", arg0);
    }

    /**
     * Key {@code XUnitValidationService.invalidInput}: {@code The file

     * ''{0}'' is an invalid file.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The file ''{0}'' is an invalid file.}
     */
    public static Localizable _XUnitValidationService_invalidInput(Object arg0) {
        return new Localizable(holder, "XUnitValidationService.invalidInput", arg0);
    }

    /**
     * Key {@code XUnitTransformerCallable.invalidInput}: {@code The result

     * file ''{0}'' for the metric ''{1}'' is not valid. The result file has

     * been skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The result file ''{0}'' for the metric ''{1}'' is not valid.

     *     The result file has been skipped.}
     */
    public static String XUnitTransformerCallable_invalidInput(Object arg0, Object arg1) {
        return holder.format("XUnitTransformerCallable.invalidInput", arg0, arg1);
    }

    /**
     * Key {@code XUnitTransformerCallable.invalidInput}: {@code The result

     * file ''{0}'' for the metric ''{1}'' is not valid. The result file has

     * been skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The result file ''{0}'' for the metric ''{1}'' is not valid.

     *     The result file has been skipped.}
     */
    public static Localizable _XUnitTransformerCallable_invalidInput(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitTransformerCallable.invalidInput", arg0, arg1);
    }

    /**
     * Key {@code XUnitTransformerCallable.invalidOutput}: {@code The

     * converted file for the result file ''{0}'' (during conversion process

     * for the metric ''{1}'') is not valid. The report file has been

     * skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The converted file for the result file ''{0}'' (during

     *     conversion process for the metric ''{1}'') is not valid. The report

     *     file has been skipped.}
     */
    public static String XUnitTransformerCallable_invalidOutput(Object arg0, Object arg1) {
        return holder.format("XUnitTransformerCallable.invalidOutput", arg0, arg1);
    }

    /**
     * Key {@code XUnitTransformerCallable.invalidOutput}: {@code The

     * converted file for the result file ''{0}'' (during conversion process

     * for the metric ''{1}'') is not valid. The report file has been

     * skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The converted file for the result file ''{0}'' (during

     *     conversion process for the metric ''{1}'') is not valid. The report

     *     file has been skipped.}
     */
    public static Localizable _XUnitTransformerCallable_invalidOutput(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitTransformerCallable.invalidOutput", arg0, arg1);
    }

    /**
     * Key {@code XUnitReportProcessorService.reportsNotFound}: {@code [{0}]

     * - No test report file(s) were found with the pattern ''{1}'' relative

     * to ''{2}'' for the testing framework ''{0}''.
     * Did you enter a pattern

     * relative to (and within) the workspace directory?
     * Did you generate the

     * result report(s) for ''{0}''?"}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] - No test report file(s) were found with the pattern

     *     ''{1}'' relative to ''{2}'' for the testing framework ''{0}''.
     *     Did you

     *     enter a pattern relative to (and within) the workspace directory?
     *     Did

     *     you generate the result report(s) for ''{0}''?"}
     */
    public static String XUnitReportProcessorService_reportsNotFound(Object arg0, Object arg1, Object arg2) {
        return holder.format("XUnitReportProcessorService.reportsNotFound", arg0, arg1, arg2);
    }

    /**
     * Key {@code XUnitReportProcessorService.reportsNotFound}: {@code [{0}]

     * - No test report file(s) were found with the pattern ''{1}'' relative

     * to ''{2}'' for the testing framework ''{0}''.
     * Did you enter a pattern

     * relative to (and within) the workspace directory?
     * Did you generate the

     * result report(s) for ''{0}''?"}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] - No test report file(s) were found with the pattern

     *     ''{1}'' relative to ''{2}'' for the testing framework ''{0}''.
     *     Did you

     *     enter a pattern relative to (and within) the workspace directory?
     *     Did

     *     you generate the result report(s) for ''{0}''?"}
     */
    public static Localizable _XUnitReportProcessorService_reportsNotFound(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "XUnitReportProcessorService.reportsNotFound", arg0, arg1, arg2);
    }

    /**
     * Key {@code XUnitTransformerCallable.empty}: {@code The result file

     * ''{0}'' for the metric ''{1}'' is empty. The result file has been

     * skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The result file ''{0}'' for the metric ''{1}'' is empty. The

     *     result file has been skipped.}
     */
    public static String XUnitTransformerCallable_empty(Object arg0, Object arg1) {
        return holder.format("XUnitTransformerCallable.empty", arg0, arg1);
    }

    /**
     * Key {@code XUnitTransformerCallable.empty}: {@code The result file

     * ''{0}'' for the metric ''{1}'' is empty. The result file has been

     * skipped.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The result file ''{0}'' for the metric ''{1}'' is empty. The

     *     result file has been skipped.}
     */
    public static Localizable _XUnitTransformerCallable_empty(Object arg0, Object arg1) {
        return new Localizable(holder, "XUnitTransformerCallable.empty", arg0, arg1);
    }

    /**
     * Key {@code XUnitReportProcessorService.reportsFound}: {@code [{0}] -

     * {1} test report file(s) were found with the pattern ''{2}'' relative

     * to ''{3}'' for the testing framework ''{0}''.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] - {1} test report file(s) were found with the pattern

     *     ''{2}'' relative to ''{3}'' for the testing framework ''{0}''.}
     */
    public static String XUnitReportProcessorService_reportsFound(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("XUnitReportProcessorService.reportsFound", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code XUnitReportProcessorService.reportsFound}: {@code [{0}] -

     * {1} test report file(s) were found with the pattern ''{2}'' relative

     * to ''{3}'' for the testing framework ''{0}''.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] - {1} test report file(s) were found with the pattern

     *     ''{2}'' relative to ''{3}'' for the testing framework ''{0}''.}
     */
    public static Localizable _XUnitReportProcessorService_reportsFound(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "XUnitReportProcessorService.reportsFound", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code XUnitValidationService.invalidOutput}: {@code The converted

     * file for the input file ''{0}'' doesn't match the JUnit format.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The converted file for the input file ''{0}'' doesn't match the

     *     JUnit format.}
     */
    public static String XUnitValidationService_invalidOutput(Object arg0) {
        return holder.format("XUnitValidationService.invalidOutput", arg0);
    }

    /**
     * Key {@code XUnitValidationService.invalidOutput}: {@code The converted

     * file for the input file ''{0}'' doesn't match the JUnit format.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The converted file for the input file ''{0}'' doesn't match the

     *     JUnit format.}
     */
    public static Localizable _XUnitValidationService_invalidOutput(Object arg0) {
        return new Localizable(holder, "XUnitValidationService.invalidOutput", arg0);
    }

    /**
     * Key {@code XUnitReportProcessorService.clockOutOfSync}: {@code Clock

     * on this slave is out of sync with the master, and therefore 
     * I can't

     * figure out what test results are new and what are old.
     * Please keep the

     * slave clock in sync with the master.}.
     * 
     * @return
     *     {@code Clock on this slave is out of sync with the master, and

     *     therefore 
     *     I can't figure out what test results are new and what are

     *     old.
     *     Please keep the slave clock in sync with the master.}
     */
    public static String XUnitReportProcessorService_clockOutOfSync() {
        return holder.format("XUnitReportProcessorService.clockOutOfSync");
    }

    /**
     * Key {@code XUnitReportProcessorService.clockOutOfSync}: {@code Clock

     * on this slave is out of sync with the master, and therefore 
     * I can't

     * figure out what test results are new and what are old.
     * Please keep the

     * slave clock in sync with the master.}.
     * 
     * @return
     *     {@code Clock on this slave is out of sync with the master, and

     *     therefore 
     *     I can't figure out what test results are new and what are

     *     old.
     *     Please keep the slave clock in sync with the master.}
     */
    public static Localizable _XUnitReportProcessorService_clockOutOfSync() {
        return new Localizable(holder, "XUnitReportProcessorService.clockOutOfSync");
    }

}
