/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.task.compatibility;

import com.xpandit.plugins.xrayjenkins.Utils.ConfigurationUtils;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import com.xpandit.plugins.xrayjenkins.task.XrayImportBuilder;
import com.xpandit.plugins.xrayjenkins.task.compatibility.CompatibilityDelegate;
import com.xpandit.xray.model.Endpoint;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class XrayImportBuilderCompatibilityDelegate
implements CompatibilityDelegate {
    private static final String INPUT_INFO_SWITCHER = "inputInfoSwitcher";
    private static final String TEST_ENVIRONMENTS = "testEnvironments";
    private static final String PROJECT_KEY = "projectKey";
    private static final String TEST_PLAN_KEY = "testPlanKey";
    private static final String FIX_VERSION = "fixVersion";
    private static final String IMPORT_FILE_PATH = "importFilePath";
    private static final String TEST_EXEC_KEY = "testExecKey";
    private static final String REVISION_FIELD = "revision";
    private static final String IMPORT_INFO = "importInfo";
    private XrayImportBuilder xrayImportBuilder;

    public XrayImportBuilderCompatibilityDelegate(XrayImportBuilder xrayImportBuilder) {
        this.xrayImportBuilder = xrayImportBuilder;
    }

    @Override
    public void applyCompatibility() {
        if (this.needForwardCompatibility()) {
            this.applyForwardCompatibility();
        } else {
            this.applyBackwardCompatibility();
        }
    }

    private void applyForwardCompatibility() {
        this.xrayImportBuilder.setEndpointName(this.xrayImportBuilder.getEndpoint().getSuffix());
        this.xrayImportBuilder.setProjectKey(this.xrayImportBuilder.getDynamicFields().get(PROJECT_KEY));
        this.xrayImportBuilder.setTestEnvironments(this.xrayImportBuilder.getDynamicFields().get(TEST_ENVIRONMENTS));
        this.xrayImportBuilder.setTestPlanKey(this.xrayImportBuilder.getDynamicFields().get(TEST_PLAN_KEY));
        this.xrayImportBuilder.setFixVersion(this.xrayImportBuilder.getDynamicFields().get(FIX_VERSION));
        this.xrayImportBuilder.setImportFilePath(this.xrayImportBuilder.getDynamicFields().get(IMPORT_FILE_PATH));
        this.xrayImportBuilder.setTestExecKey(this.xrayImportBuilder.getDynamicFields().get(TEST_EXEC_KEY));
        this.xrayImportBuilder.setRevision(this.xrayImportBuilder.getDynamicFields().get(REVISION_FIELD));
        this.xrayImportBuilder.setImportInfo(this.xrayImportBuilder.getDynamicFields().get(IMPORT_INFO));
        this.xrayImportBuilder.setImportToSameExecution("true");
    }

    private boolean needForwardCompatibility() {
        return this.xrayImportBuilder.getEndpointName() == null && this.xrayImportBuilder.getProjectKey() == null && this.xrayImportBuilder.getTestEnvironments() == null && this.xrayImportBuilder.getTestPlanKey() == null && this.xrayImportBuilder.getFixVersion() == null && this.xrayImportBuilder.getImportFilePath() == null && this.xrayImportBuilder.getTestExecKey() == null && this.xrayImportBuilder.getRevision() == null && this.xrayImportBuilder.getImportInfo() == null && this.xrayImportBuilder.getImportToSameExecution() == null;
    }

    private void applyBackwardCompatibility() {
        XrayInstance instance = ConfigurationUtils.getConfiguration(this.xrayImportBuilder.getServerInstance());
        this.xrayImportBuilder.setXrayInstance(instance);
        this.xrayImportBuilder.setEndpoint(this.lookupForEndpoint(this.xrayImportBuilder.getEndpointName()));
        this.xrayImportBuilder.setDynamicFields(this.getDynamicFieldsMap());
    }

    private Map<String, String> getDynamicFieldsMap() {
        HashMap<String, String> fields = new HashMap<String, String>();
        this.putNotBlank(fields, PROJECT_KEY, this.xrayImportBuilder.getProjectKey());
        this.putNotBlank(fields, TEST_ENVIRONMENTS, this.xrayImportBuilder.getTestEnvironments());
        this.putNotBlank(fields, TEST_PLAN_KEY, this.xrayImportBuilder.getTestPlanKey());
        this.putNotBlank(fields, FIX_VERSION, this.xrayImportBuilder.getFixVersion());
        this.putNotBlank(fields, IMPORT_FILE_PATH, this.xrayImportBuilder.getImportFilePath());
        this.putNotBlank(fields, TEST_EXEC_KEY, this.xrayImportBuilder.getTestExecKey());
        this.putNotBlank(fields, REVISION_FIELD, this.xrayImportBuilder.getRevision());
        this.putNotBlank(fields, IMPORT_INFO, this.xrayImportBuilder.getImportInfo());
        this.putNotBlank(fields, INPUT_INFO_SWITCHER, this.xrayImportBuilder.getInputInfoSwitcher());
        return fields;
    }

    private void putNotBlank(Map<String, String> fields, String key, String val) {
        if (StringUtils.isNotBlank((CharSequence)val)) {
            fields.put(key, val);
        }
    }

    @Nullable
    private Endpoint lookupForEndpoint(String endpointName) {
        Endpoint targetedEndpoint = Endpoint.lookupByName((String)endpointName);
        return targetedEndpoint != null ? targetedEndpoint : Endpoint.lookupBySuffix((String)endpointName);
    }
}

