/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.task;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.xpandit.plugins.xrayjenkins.Utils.BuilderUtils;
import com.xpandit.plugins.xrayjenkins.Utils.ConfigurationUtils;
import com.xpandit.plugins.xrayjenkins.Utils.CredentialUtil;
import com.xpandit.plugins.xrayjenkins.Utils.EnvironmentVariableUtil;
import com.xpandit.plugins.xrayjenkins.Utils.FileUtils;
import com.xpandit.plugins.xrayjenkins.Utils.FormUtils;
import com.xpandit.plugins.xrayjenkins.Utils.ProxyUtil;
import com.xpandit.plugins.xrayjenkins.exceptions.XrayJenkinsGenericException;
import com.xpandit.plugins.xrayjenkins.factory.ClientFactory;
import com.xpandit.plugins.xrayjenkins.model.CredentialResolver;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.model.ServerConfiguration;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import com.xpandit.plugins.xrayjenkins.services.enviromentvariables.XrayEnvironmentVariableSetter;
import com.xpandit.plugins.xrayjenkins.task.compatibility.XrayExportBuilderCompatibilityDelegate;
import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.service.XrayExporter;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayExportBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOG = LoggerFactory.getLogger(XrayExportBuilder.class);
    @Deprecated
    private XrayInstance xrayInstance;
    @Deprecated
    private Map<String, String> fields;
    private String serverInstance;
    private String issues;
    private String filter;
    private String filePath;
    private String credentialId;

    @DataBoundConstructor
    public XrayExportBuilder(String serverInstance, String issues, String filter, String filePath, String credentialId) {
        this.issues = issues;
        this.filter = filter;
        this.filePath = filePath;
        this.serverInstance = serverInstance;
        this.credentialId = credentialId;
        this.xrayInstance = ConfigurationUtils.getConfiguration(serverInstance);
        this.fields = this.getFieldsMap(issues, filter, filePath);
    }

    private Map<String, String> getFieldsMap(String issues, String filter, String filePath) {
        HashMap<String, String> fields = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)issues)) {
            fields.put("issues", issues);
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            fields.put("filter", filter);
        }
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            fields.put("filePath", filePath);
        }
        return fields;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        XrayExporter client;
        XrayExportBuilderCompatibilityDelegate compatibilityDelegate = new XrayExportBuilderCompatibilityDelegate(this);
        compatibilityDelegate.applyCompatibility();
        listener.getLogger().println("Starting XRAY: Cucumber Features Export Task...");
        listener.getLogger().println("##########################################################");
        listener.getLogger().println("####   Xray is exporting the feature files  ####");
        listener.getLogger().println("##########################################################");
        XrayInstance xrayInstance = ConfigurationUtils.getConfiguration(this.serverInstance);
        if (xrayInstance == null) {
            listener.getLogger().println("XrayInstance is null. please check the passed configuration ID");
            XrayEnvironmentVariableSetter.failed("XrayInstance is null. please check the passed configuration ID").setAction(build, listener);
            throw new AbortException("The Jira server configuration of this task was not found.");
        }
        if (StringUtils.isBlank((CharSequence)xrayInstance.getCredentialId()) && StringUtils.isBlank((CharSequence)this.credentialId)) {
            listener.getLogger().println("This XrayInstance requires an User scoped credential.");
            XrayEnvironmentVariableSetter.failed("This XrayInstance requires an User scoped credential.").setAction(build, listener);
            throw new AbortException("This XrayInstance requires an User scoped credential.");
        }
        CredentialResolver credentialResolver = xrayInstance.getCredential(build).orElseGet(() -> new CredentialResolver(this.credentialId, build, xrayInstance.getHosting()));
        HttpRequestProvider.ProxyBean proxyBean = ProxyUtil.createProxyBean();
        StandardCredentials credentials = credentialResolver.getCredentials();
        if (credentials == null) {
            String credentialIdNotFound = Optional.ofNullable(xrayInstance.getCredentialId()).filter(StringUtils::isNotBlank).orElse(this.credentialId);
            String errorTxt = String.format("Unable to create Xray %s feature export client! Credential '%s' not found. For Cloud instances: Secret Text credentials are not allowed", xrayInstance.getHosting().name(), credentialIdNotFound);
            throw new AbortException(errorTxt);
        }
        if (xrayInstance.getHosting() == HostingType.CLOUD) {
            client = ClientFactory.getCloudFeatureExportClient(credentials, proxyBean).orElseThrow(() -> new XrayJenkinsGenericException("Unable to create Xray Cloud feature export client! (check credential type selected)."));
        } else if (xrayInstance.getHosting() == null || xrayInstance.getHosting() == HostingType.SERVER) {
            client = ClientFactory.getServerFeatureExportClient(xrayInstance.getServerAddress(), credentials, proxyBean).orElseThrow(() -> new XrayJenkinsGenericException("Unable to create Xray Server feature export client! (check credential type selected)."));
        } else {
            XrayEnvironmentVariableSetter.failed("Hosting type not recognized.").setAction(build, listener);
            throw new XrayJenkinsGenericException("Hosting type not recognized.");
        }
        try {
            EnvVars env = build.getEnvironment(listener);
            String expandedIssues = EnvironmentVariableUtil.expandVariable(env, this.issues);
            String expandedFilter = EnvironmentVariableUtil.expandVariable(env, this.filter);
            String expandedFilePath = EnvironmentVariableUtil.expandVariable(env, this.filePath);
            if (StringUtils.isNotBlank((CharSequence)expandedIssues)) {
                listener.getLogger().println("Issues: " + expandedIssues);
            }
            if (StringUtils.isNotBlank((CharSequence)expandedFilter)) {
                listener.getLogger().println("Filter: " + expandedFilter);
            }
            if (StringUtils.isNotBlank((CharSequence)expandedFilePath)) {
                listener.getLogger().println("Will save the feature files in: " + expandedFilePath);
            }
            InputStream file = client.downloadFeatures(expandedIssues, expandedFilter, "true");
            this.unzipFeatures(listener, workspace, expandedFilePath, file);
            FileUtils.closeSilently(file);
            listener.getLogger().println("Successfully exported the Cucumber features");
            XrayEnvironmentVariableSetter.success().setAction(build, listener);
        }
        catch (XrayClientCoreGenericException | IOException | InterruptedException e) {
            e.printStackTrace();
            listener.error(e.getMessage());
            XrayEnvironmentVariableSetter.failed().setAction(build, listener);
            throw new AbortException(e.getMessage());
        }
    }

    private void unzipFeatures(TaskListener listener, FilePath workspace, String filePath, InputStream zip) throws IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = "features/";
        }
        FilePath outputFile = new FilePath(workspace, filePath.trim());
        listener.getLogger().println("###################### Unzipping file ####################");
        outputFile.mkdirs();
        outputFile.unzipFrom(zip);
        listener.getLogger().println("###################### Unzipped file #####################");
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public void setServerInstance(String serverInstance) {
        this.serverInstance = serverInstance;
    }

    public String getIssues() {
        return this.issues;
    }

    public void setIssues(String issues) {
        this.issues = issues;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public XrayInstance getXrayInstance() {
        return this.xrayInstance;
    }

    @DataBoundSetter
    public void setXrayInstance(XrayInstance xrayInstance) {
        this.xrayInstance = xrayInstance;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    @DataBoundSetter
    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            super(XrayExportBuilder.class);
            this.load();
        }

        public synchronized void load() {
            super.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public XrayExportBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.validateFormData(formData);
            Map<String, String> fields = this.getFields(formData.getJSONObject("fields"));
            return new XrayExportBuilder(formData.getString("serverInstance"), fields.get("issues"), fields.get("filter"), fields.get("filePath"), formData.getString("credentialId"));
        }

        private void validateFormData(JSONObject formData) throws Descriptor.FormException {
            if (StringUtils.isBlank((CharSequence)formData.getString("serverInstance"))) {
                throw new Descriptor.FormException("Xray Cucumber Features Export Task error, you must provide a valid Jira Instance", "serverInstance");
            }
        }

        public ListBoxModel doFillServerInstanceItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return FormUtils.getServerInstanceItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item, @QueryParameter String credentialId) {
            return CredentialUtil.getUserScopedCredentialsListBoxModel(item, credentialId);
        }

        private Map<String, String> getFields(JSONObject configuredFields) {
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String key : configuredFields.keySet()) {
                String value;
                if (!configuredFields.containsKey((Object)key) || !StringUtils.isNotBlank((CharSequence)(value = configuredFields.getString(key)))) continue;
                fields.put(key, value);
            }
            return Collections.unmodifiableMap(fields);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            LOG.info("applying XrayExportBuilder to following jobType class: {}", (Object)jobType.getSimpleName());
            return BuilderUtils.isSupportedJobType(jobType);
        }

        public String getDisplayName() {
            return "Xray: Cucumber Features Export Task";
        }

        public FormValidation doCheckFilePath(@QueryParameter String value) {
            if (value.contains("../")) {
                return FormValidation.error((String)"You can't provide file paths for upper directories.Please don't use \"../\".");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIssues(@QueryParameter String value, @QueryParameter String filter) {
            if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)filter)) {
                return FormValidation.error((String)"You must provide issue keys and/or a filter ID in order to export cucumber features from Xray.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFilter(@QueryParameter String value, @QueryParameter String issues) {
            if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)issues)) {
                return FormValidation.error((String)"You must provide issue keys and/or a filter ID in order to export cucumber features from Xray.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerInstance(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return ConfigurationUtils.anyAvailableConfiguration() ? FormValidation.ok() : FormValidation.error((String)"No configured Server Instances.");
        }

        public FormValidation doCheckCredentialId(@QueryParameter String value, @QueryParameter String serverInstance) {
            XrayInstance xrayInstance = ConfigurationUtils.getConfigurationOrFirstAvailable(serverInstance);
            if (xrayInstance != null && StringUtils.isBlank((CharSequence)xrayInstance.getCredentialId()) && StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"This XrayInstance requires an User scoped credential.");
            }
            return FormValidation.ok();
        }

        public List<XrayInstance> getServerInstances() {
            return ServerConfiguration.get().getServerInstances();
        }

        public String getUuid() {
            return UUID.randomUUID().toString();
        }
    }
}

