/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.services.enviromentvariables;

import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.services.enviromentvariables.XrayEnvironmentInjectAction;
import com.xpandit.plugins.xrayjenkins.services.enviromentvariables.util.XrayEnvironmentVariableSetterUtil;
import com.xpandit.xray.model.UploadResult;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class XrayEnvironmentVariableSetter {
    private final Map<XrayEnvironmentVariable, String> newVariables = Collections.synchronizedMap(new HashMap());

    private XrayEnvironmentVariableSetter() {
        for (XrayEnvironmentVariable variable : XrayEnvironmentVariable.values()) {
            this.newVariables.put(variable, "");
        }
    }

    public static XrayEnvironmentVariableSetter parseCucumberFeatureImportResponse(Collection<UploadResult> results, HostingType hostingType, PrintStream logger) {
        XrayEnvironmentVariableSetter variableSetter = new XrayEnvironmentVariableSetter();
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_RAW_RESPONSE, XrayEnvironmentVariableSetterUtil.getRawResponses(results));
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_IS_REQUEST_SUCCESSFUL, XrayEnvironmentVariableSetterUtil.isUploadSuccessful(results));
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_ISSUES_MODIFIED, XrayEnvironmentVariableSetterUtil.getImportedFeatureIssueKeys(results, hostingType, logger));
        return variableSetter;
    }

    public static XrayEnvironmentVariableSetter parseResultImportResponse(Collection<UploadResult> results, HostingType hostingType, PrintStream logger) {
        if (results == null) {
            return XrayEnvironmentVariableSetter.failed();
        }
        XrayEnvironmentVariableSetter variableSetter = new XrayEnvironmentVariableSetter();
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_RAW_RESPONSE, XrayEnvironmentVariableSetterUtil.getRawResponses(results));
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_IS_REQUEST_SUCCESSFUL, XrayEnvironmentVariableSetterUtil.isUploadSuccessful(results));
        String testExecKeys = XrayEnvironmentVariableSetterUtil.getModifiedTestExecutionsKeys(results, hostingType, logger);
        String testKeys = XrayEnvironmentVariableSetterUtil.getModifiedTestKeys(results, hostingType, logger);
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_TEST_EXECS, testExecKeys);
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_TESTS, testKeys);
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_ISSUES_MODIFIED, XrayEnvironmentVariableSetter.getAllKeys(testExecKeys, testKeys));
        return variableSetter;
    }

    public static XrayEnvironmentVariableSetter success() {
        return XrayEnvironmentVariableSetter.success(null);
    }

    public static XrayEnvironmentVariableSetter success(@Nullable String message) {
        XrayEnvironmentVariableSetter variableSetter = new XrayEnvironmentVariableSetter();
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_IS_REQUEST_SUCCESSFUL, XrayEnvironmentVariableSetterUtil.TRUE_STRING);
        if (message != null) {
            variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_RAW_RESPONSE, message);
        }
        return variableSetter;
    }

    public static XrayEnvironmentVariableSetter failed() {
        return XrayEnvironmentVariableSetter.failed(null);
    }

    public static XrayEnvironmentVariableSetter failed(@Nullable String message) {
        XrayEnvironmentVariableSetter variableSetter = new XrayEnvironmentVariableSetter();
        variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_IS_REQUEST_SUCCESSFUL, XrayEnvironmentVariableSetterUtil.FALSE_STRING);
        if (message != null) {
            variableSetter.newVariables.put(XrayEnvironmentVariable.XRAY_RAW_RESPONSE, message);
        }
        return variableSetter;
    }

    public void setAction(Run<?, ?> build, TaskListener taskListener) {
        this.setAction(build, taskListener.getLogger());
    }

    private void setAction(Run<?, ?> build, @Nullable PrintStream logger) {
        if (build != null) {
            Map<String, String> newVariablesByName = this.getVariableValuesByName(logger);
            XrayEnvironmentInjectAction action = new XrayEnvironmentInjectAction(newVariablesByName);
            build.addOrReplaceAction((Action)action);
        }
    }

    private Map<String, String> getVariableValuesByName(@Nullable PrintStream logger) {
        HashMap<String, String> newVariablesByName = new HashMap<String, String>();
        for (Map.Entry<XrayEnvironmentVariable, String> entry : this.newVariables.entrySet()) {
            String variableName = entry.getKey().name();
            String variableValue = entry.getValue();
            newVariablesByName.put(variableName, variableValue);
            if (logger == null) continue;
            logger.println(variableName + ": " + variableValue);
        }
        return newVariablesByName;
    }

    private static String getAllKeys(String ... allKeys) {
        ArrayList<String> keyList = new ArrayList<String>(allKeys.length);
        for (String keys : allKeys) {
            if (!StringUtils.isNotBlank((CharSequence)keys)) continue;
            keyList.add(keys);
        }
        return StringUtils.join(keyList, (char)';');
    }

    private static enum XrayEnvironmentVariable {
        XRAY_IS_REQUEST_SUCCESSFUL,
        XRAY_ISSUES_MODIFIED,
        XRAY_RAW_RESPONSE,
        XRAY_TEST_EXECS,
        XRAY_TESTS;

    }
}

