/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.common.collect.Lists;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialUtil {
    private CredentialUtil() {
    }

    public static List<StandardCredentials> getAllSystemCredentials(@Nullable Item item) {
        if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return CredentialUtil.getStandardCredentials(item, ACL.SYSTEM);
        }
        return Collections.emptyList();
    }

    public static boolean hasNonUsernamePasswordCredentials(Collection<StandardCredentials> credentials, Set<String> credentialIds) {
        return !credentials.stream().filter(Objects::nonNull).filter(instance -> credentialIds.contains(instance.getId())).allMatch(UsernamePasswordCredentials.class::isInstance);
    }

    public static ListBoxModel getAllCredentialsListBoxModel(@Nullable Item item, String credentialId) {
        return CredentialUtil.getCredentialsListBoxModel(credentialId, CredentialUtil.getAllSystemCredentials(item));
    }

    public static List<StandardCredentials> getAllUserScopedCredentials(@Nullable Item item) {
        return CredentialUtil.getAllUserScopedCredentials(item, Jenkins.getAuthentication());
    }

    public static List<StandardCredentials> getAllUserScopedCredentials(@Nullable Item item, @Nullable Authentication authentication) {
        return Jenkins.get().hasPermission(CredentialsProvider.USE_OWN) ? CredentialUtil.getStandardCredentials(item, authentication) : Collections.emptyList();
    }

    public static ListBoxModel getUserScopedCredentialsListBoxModel(@Nullable Item item, String credentialId) {
        return CredentialUtil.getCredentialsListBoxModel(credentialId, CredentialUtil.getAllUserScopedCredentials(item));
    }

    private static ListBoxModel getCredentialsListBoxModel(String credentialId, List<StandardCredentials> credentials) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        for (StandardCredentials credential : credentials) {
            result.with((IdCredentials)credential);
        }
        return result.includeCurrentValue(credentialId);
    }

    private static List<StandardCredentials> getStandardCredentials(@Nullable Item item, @Nullable Authentication authentication) {
        List usernamePasswordCredentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)authentication, Collections.emptyList());
        List secretTextCredentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)authentication, Collections.emptyList());
        ArrayList credentials = Lists.newArrayList();
        credentials.addAll(usernamePasswordCredentials);
        credentials.addAll(secretTextCredentials);
        return Collections.unmodifiableList(credentials);
    }
}

