/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.xpandit.plugins.xrayjenkins.exceptions.XrayJenkinsGenericException;
import com.xpandit.xray.model.Endpoint;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import org.apache.commons.lang3.StringUtils;

public class BuilderUtils {
    private static final String SLASH_SEPARATED_REGEX = "/";
    private static final String BETWEEN_BRACES_REGEX = "^\\$\\{.*\\}$";
    private static final int GENERIC_NAME_ARRAY_POSITION = 1;

    public static boolean isSupportedJobType(Class<? extends AbstractProject> jobType) {
        return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType) || MavenModuleSet.class.isAssignableFrom(jobType);
    }

    public static boolean isGlobExpressionsSupported(Endpoint endpointValue) {
        return Endpoint.JUNIT.equals((Object)endpointValue) || Endpoint.NUNIT.equals((Object)endpointValue) || Endpoint.TESTNG.equals((Object)endpointValue) || Endpoint.ROBOT.equals((Object)endpointValue) || Endpoint.XUNIT.equals((Object)endpointValue) || Endpoint.JUNIT_MULTIPART.equals((Object)endpointValue) || Endpoint.ROBOT_MULTIPART.equals((Object)endpointValue) || Endpoint.TESTNG_MULTIPART.equals((Object)endpointValue) || Endpoint.NUNIT_MULTIPART.equals((Object)endpointValue) || Endpoint.XUNIT_MULTIPART.equals((Object)endpointValue);
    }

    public static Endpoint getGenericEndpointFromMultipartSuffix(String multipartEndpointSuffix) {
        String[] multipartEndpointSuffixSeparated = multipartEndpointSuffix.split(SLASH_SEPARATED_REGEX);
        if (multipartEndpointSuffixSeparated.length < 1) {
            throw new XrayJenkinsGenericException("The new endpoint suffix could not be extracted from the endpoint suffix received: " + multipartEndpointSuffix);
        }
        String genericEndpointName = SLASH_SEPARATED_REGEX + multipartEndpointSuffixSeparated[1];
        Endpoint newEndpoint = Endpoint.lookupBySuffix((String)genericEndpointName);
        if (newEndpoint == null) {
            throw new XrayJenkinsGenericException("No file path was specified");
        }
        return newEndpoint;
    }

    public static boolean isEnvVariableUndefined(String variable) {
        return StringUtils.isEmpty((CharSequence)variable) || variable.trim().matches(BETWEEN_BRACES_REGEX);
    }
}

