/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.versioncolumn;

import hudson.plugin.versioncolumn.Messages;
import java.util.List;

class JVMVersionComparator {
    private boolean compatible;

    JVMVersionComparator(Runtime.Version controllerVersion, Runtime.Version agentVersion, ComparisonMode comparisonMode) {
        if (ComparisonMode.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE == comparisonMode) {
            this.compatible = agentVersion.feature() >= controllerVersion.feature();
        } else if (ComparisonMode.EXACT_MATCH == comparisonMode) {
            this.compatible = controllerVersion.version().equals(agentVersion.version());
        } else if (ComparisonMode.MAJOR_MINOR_MATCH == comparisonMode) {
            this.compatible = JVMVersionComparator.compareVersionList(agentVersion.version(), controllerVersion.version()) >= 0;
        }
    }

    private static int compareVersionList(List<Integer> o1, List<Integer> o2) {
        int size1 = o1.size();
        int size2 = o2.size();
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            int value2;
            int value1 = o1.get(i);
            if (value1 == (value2 = o2.get(i).intValue())) continue;
            return value1 - value2;
        }
        return size1 - size2;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public boolean isNotCompatible() {
        return !this.isCompatible();
    }

    public static enum ComparisonMode {
        RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE(Messages.JVMVersionMonitor_RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE()),
        MAJOR_MINOR_MATCH(Messages.JVMVersionMonitor_MAJOR_MINOR_MATCH()),
        EXACT_MATCH(Messages.JVMVersionMonitor_EXACT_MATCH());

        private String description;

        private ComparisonMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

