/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.service;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Date;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.urltrigger.URLTriggerEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;

public class URLTriggerService {
    private static URLTriggerService INSTANCE = new URLTriggerService();

    private URLTriggerService() {
    }

    public static URLTriggerService getInstance() {
        return INSTANCE;
    }

    public void initContent(ClientResponse clientResponse, URLTriggerEntry entry) throws XTriggerException {
        if (clientResponse == null) {
            throw new NullPointerException("The given clientResponse object is not set.");
        }
        if (entry == null) {
            throw new NullPointerException("The given entry object is not set.");
        }
        Date lastModified = clientResponse.getLastModified();
        if (lastModified != null) {
            entry.setLastModificationDate(lastModified.getTime());
        } else {
            entry.setLastModificationDate(0L);
        }
        if (entry.isInspectingContent()) {
            for (URLTriggerContentType type : entry.getContentTypes()) {
                String stringContent = (String)clientResponse.getEntity(String.class);
                if (stringContent == null) {
                    throw new XTriggerException("The URL content is empty.");
                }
                type.initForContent(stringContent);
            }
        }
    }

    public boolean isSchedulingAndGetRefresh(ClientResponse clientResponse, URLTriggerEntry entry, XTriggerLog log) throws XTriggerException {
        boolean job2Schedule = false;
        if (entry.isCheckStatus()) {
            job2Schedule = this.checkStatus(entry, log, clientResponse.getStatus());
        }
        if (entry.isCheckLastModificationDate()) {
            Date lastModificationDate = clientResponse.getLastModified();
            job2Schedule = job2Schedule || this.checkLastModificationDate(entry, log, lastModificationDate);
            this.refreshLatModificationDate(entry, lastModificationDate);
        }
        if (entry.isInspectingContent()) {
            String content = (String)clientResponse.getEntity(String.class);
            job2Schedule = job2Schedule || this.checkContent(entry, log, content);
            this.refreshContent(entry, content);
        }
        return job2Schedule;
    }

    private void refreshLatModificationDate(URLTriggerEntry entry, Date lastModificationDate) {
        if (lastModificationDate != null) {
            entry.setLastModificationDate(lastModificationDate.getTime());
        } else {
            entry.setLastModificationDate(0L);
        }
    }

    private void refreshContent(URLTriggerEntry entry, String content) throws XTriggerException {
        for (URLTriggerContentType type : entry.getContentTypes()) {
            type.initForContent(content);
        }
    }

    private boolean checkStatus(URLTriggerEntry entry, XTriggerLog log, int status) throws XTriggerException {
        if (status == entry.getStatusCode()) {
            log.info(String.format("The returned status matches the expected status: \n %s", entry.getUrl()));
            return true;
        }
        return false;
    }

    private boolean checkLastModificationDate(URLTriggerEntry entry, XTriggerLog log, Date clientLastModificationDate) throws XTriggerException {
        boolean isTriggering = false;
        if (clientLastModificationDate != null) {
            long newLastModifiedDateTime = clientLastModificationDate.getTime();
            long previousLastModificationDateTime = entry.getLastModificationDate();
            if (previousLastModificationDateTime != 0L && previousLastModificationDateTime != newLastModifiedDateTime) {
                log.info("The last modification date has changed.");
                isTriggering = true;
            }
        }
        return isTriggering;
    }

    private boolean checkContent(URLTriggerEntry entry, XTriggerLog log, String content) throws XTriggerException {
        if (content == null) {
            return false;
        }
        log.info("Inspecting the content");
        for (URLTriggerContentType type : entry.getContentTypes()) {
            boolean isTriggering = type.isTriggeringBuildForContent(content, log);
            if (!isTriggering) continue;
            return true;
        }
        return false;
    }
}

