/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content;

import hudson.Extension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.urltrigger.content.TEXTContentEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TEXTContentType
extends URLTriggerContentType {
    private List<TEXTContentEntry> regExElements = new ArrayList<TEXTContentEntry>();

    @DataBoundConstructor
    public TEXTContentType(List<TEXTContentEntry> element) {
        if (element != null) {
            this.regExElements = element;
        }
    }

    public List<TEXTContentEntry> getRegExElements() {
        return this.regExElements;
    }

    @Override
    public void initForContentType(String content) throws XTriggerException {
    }

    @Override
    public boolean isTriggeringBuildForContent(String content, XTriggerLog log) throws XTriggerException {
        StringReader stringReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            stringReader = new StringReader(content);
            bufferedReader = new BufferedReader(stringReader);
            while ((line = bufferedReader.readLine()) != null) {
                for (TEXTContentEntry regexEntry : this.regExElements) {
                    Pattern pattern = Pattern.compile(regexEntry.getRegEx());
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    log.info(String.format("The line '%s' matches the pattern '%s'", line, pattern));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    throw new XTriggerException((Throwable)ioe);
                }
            }
            if (stringReader != null) {
                stringReader.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class TEXTContentDescriptor
    extends URLTriggerContentTypeDescriptor<TEXTContentType> {
        @Override
        public Class<? extends URLTriggerContentType> getType() {
            return TEXTContentType.class;
        }

        public String getDisplayName() {
            return "Monitor the contents of a TEXT response";
        }

        @Override
        public String getLabel() {
            return "TXT";
        }
    }
}

