/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content;

import hudson.Extension;
import hudson.Util;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimpleContentType
extends URLTriggerContentType {
    private transient String md5;

    @DataBoundConstructor
    public SimpleContentType() {
    }

    public void initForContentType(String content) throws XTriggerException {
        this.md5 = Util.getDigestOf((String)content);
    }

    public boolean isTriggeringBuildForContent(String content, XTriggerLog log) throws XTriggerException {
        assert (this.md5 != null);
        String newComputedMd5 = Util.getDigestOf((String)content);
        if (!newComputedMd5.equals(this.md5)) {
            log.info("The content of the URL has changed.");
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class SimpleFileContentDescriptor
    extends URLTriggerContentTypeDescriptor<SimpleContentType> {
        @Override
        public Class<? extends URLTriggerContentType> getType() {
            return SimpleContentType.class;
        }

        public String getDisplayName() {
            return "Monitor a change of the content";
        }

        @Override
        public String getLabel() {
            return this.getDisplayName();
        }
    }
}

