/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger;

import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.jelly.XMLOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLTriggerAction
implements Action {
    private transient AbstractProject<?, ?> job;
    private transient File logFile;
    private transient String label;
    private transient Map<String, String> subActionTitle;

    public URLTriggerAction(AbstractProject<?, ?> job, File logFile, String label, Map<String, String> subActionTitle) {
        this.job = job;
        this.logFile = logFile;
        this.label = label;
        this.subActionTitle = subActionTitle;
    }

    public AbstractProject<?, ?> getOwner() {
        return this.job;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public String getDisplayName() {
        return "URLTrigger Log";
    }

    public String getUrlName() {
        return "urltriggerPollLog";
    }

    public String getLog() throws IOException {
        return Util.loadFile((File)this.getLogFile());
    }

    public Map<String, String> getSubActionTitle() {
        return this.subActionTitle;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void writeLogTo(XMLOutput out) throws IOException {
        new AnnotatedLargeText(this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
    }
}

