/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger;

import antlr.ANTLRException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.SequentialExecutionQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jenkinsci.lib.xtrigger.AbstractTrigger;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.lib.xtrigger.service.XTriggerEnvVarsResolver;
import org.jenkinsci.plugins.urltrigger.Messages;
import org.jenkinsci.plugins.urltrigger.URLTriggerAction;
import org.jenkinsci.plugins.urltrigger.URLTriggerEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.jenkinsci.plugins.urltrigger.service.URLTriggerService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLTrigger
extends AbstractTrigger {
    private static Logger LOGGER = Logger.getLogger(URLTrigger.class.getName());
    private List<URLTriggerEntry> entries = new ArrayList<URLTriggerEntry>();

    @DataBoundConstructor
    public URLTrigger(String cronTabSpec, List<URLTriggerEntry> entries) throws ANTLRException {
        super(cronTabSpec);
        this.entries = entries;
    }

    public List<URLTriggerEntry> getEntries() {
        return this.entries;
    }

    public Collection<? extends Action> getProjectActions() {
        HashMap<String, String> subActionTitles = null;
        for (URLTriggerEntry entry : this.entries) {
            String url = entry.getUrl();
            URLTriggerContentType[] urlTriggerContentTypes = entry.getContentTypes();
            if (entry.getContentTypes() == null) continue;
            subActionTitles = new HashMap<String, String>(urlTriggerContentTypes.length);
            for (URLTriggerContentType fsTriggerContentFileType : urlTriggerContentTypes) {
                Descriptor<URLTriggerContentType> descriptor;
                if (fsTriggerContentFileType == null || !((descriptor = fsTriggerContentFileType.getDescriptor()) instanceof URLTriggerContentTypeDescriptor)) continue;
                subActionTitles.put(url, ((URLTriggerContentTypeDescriptor)descriptor).getLabel());
            }
        }
        URLTriggerAction action = new URLTriggerAction((AbstractProject)this.job, this.getLogFile(), this.getDescriptor().getDisplayName(), subActionTitles);
        return Collections.singleton(action);
    }

    private Node getLauncherNode(XTriggerLog log) {
        AbstractProject p = (AbstractProject)this.job;
        Label label = p.getAssignedLabel();
        if (label == null) {
            log.info("Running on master.");
            return this.getLauncherNodeMaster();
        }
        log.info(String.format("Searching a node to run the polling for the label '%s'.", label));
        return this.getLauncherNodeSlave(p, label, log);
    }

    private Node getLauncherNodeMaster() {
        Computer computer = Hudson.getInstance().toComputer();
        if (computer != null) {
            return computer.getNode();
        }
        return null;
    }

    private Node getLauncherNodeSlave(AbstractProject project, Label label, XTriggerLog log) {
        Node lastBuildOnNode = project.getLastBuiltOn();
        boolean isAPreviousBuildNode = lastBuildOnNode != null;
        Set nodes = label.getNodes();
        for (Node node : nodes) {
            if (node == null) continue;
            if (!isAPreviousBuildNode) {
                FilePath nodePath = node.getRootPath();
                if (nodePath == null) continue;
                log.info(String.format("Running on %s.", node.getNodeName()));
                return node;
            }
            FilePath nodeRootPath = node.getRootPath();
            if (nodeRootPath == null || !nodeRootPath.equals((Object)lastBuildOnNode.getRootPath())) continue;
            log.info("Running on " + node.getNodeName());
            return lastBuildOnNode;
        }
        return null;
    }

    private String getURLValue(URLTriggerEntry entry, Node node, XTriggerLog log) throws XTriggerException {
        String entryURL = entry.getUrl();
        if (entryURL != null) {
            XTriggerEnvVarsResolver resolver = new XTriggerEnvVarsResolver();
            Map envVars = resolver.getEnvVars((AbstractProject)this.job, node, log);
            return Util.replaceMacro((String)entryURL, (Map)envVars);
        }
        return null;
    }

    public String getCause() {
        return "URLTrigger";
    }

    protected boolean checkIfModified(XTriggerLog log) throws XTriggerException {
        if (this.entries == null || this.entries.size() == 0) {
            log.info("No URLs to poll.");
            return false;
        }
        Node executionNode = this.getLauncherNode(log);
        for (URLTriggerEntry entry : this.entries) {
            Client client = this.getClientObject(entry, log);
            String url = this.getURLValue(entry, executionNode, log);
            log.info(String.format("Invoking the url: \n %s", url));
            ClientResponse clientResponse = (ClientResponse)client.resource(url).get(ClientResponse.class);
            URLTriggerService urlTriggerService = URLTriggerService.getInstance();
            if (!urlTriggerService.isSchedulingAndGetRefresh(clientResponse, entry, log)) continue;
            return true;
        }
        return false;
    }

    private Client getClientObject(URLTriggerEntry entry, XTriggerLog log) {
        Client client = this.createClient(entry);
        if (this.isAuthBasic(entry)) {
            this.addBasicAuth(entry, log, client);
        }
        return client;
    }

    private Client createClient(URLTriggerEntry entry) {
        Client client = entry.isProxyActivated() ? this.createClientWithProxy() : this.createClientWithoutProxy();
        return client;
    }

    private void addBasicAuth(URLTriggerEntry entry, XTriggerLog log, Client client) {
        if (log != null) {
            log.info(String.format("Using Basic Authentication with the user '%s'", entry.getUsername()));
        }
        String password = entry.getRealPassword();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(entry.getUsername(), password));
    }

    private Client createClientWithoutProxy() {
        DefaultClientConfig cc = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)cc);
        return client;
    }

    private Client createClientWithProxy() {
        ProxyConfiguration p;
        DefaultApacheHttpClientConfig cc = new DefaultApacheHttpClientConfig();
        Hudson h = Hudson.getInstance();
        ProxyConfiguration proxyConfiguration = p = h != null ? h.proxy : null;
        if (p != null) {
            cc.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + p.name + ":" + p.port);
            String password = this.getProxyPasswordDecrypted(p);
            cc.getState().setProxyCredentials(AuthScope.ANY_REALM, p.name, p.port, p.getUserName(), Util.fixNull((String)password));
        }
        ApacheHttpClient client = ApacheHttpClient.create((ClientConfig)cc);
        return client;
    }

    private String getProxyPasswordDecrypted(ProxyConfiguration p) {
        String passwordEncrypted = p.getPassword();
        String password = null;
        if (passwordEncrypted != null) {
            Secret secret = Secret.fromString((String)passwordEncrypted);
            password = Secret.toString((Secret)secret);
        }
        return password;
    }

    private boolean isAuthBasic(URLTriggerEntry entry) {
        return entry.getUsername() != null;
    }

    protected File getLogFile() {
        return new File(((BuildableItem)this.job).getRootDir(), "trigger-script-polling.log");
    }

    public void start(BuildableItem project, boolean newInstance) {
        super.start((Item)project, newInstance);
        URLTriggerService service = URLTriggerService.getInstance();
        try {
            for (URLTriggerEntry entry : this.entries) {
                Client client = this.getClientObject(entry, null);
                String url = entry.getUrl();
                ClientResponse clientResponse = (ClientResponse)client.resource(url).get(ClientResponse.class);
                service.initContent(clientResponse, entry);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Severe error on trigger startup " + t.getMessage());
            t.printStackTrace();
        }
    }

    public URLScriptTriggerDescriptor getDescriptor() {
        return (URLScriptTriggerDescriptor)Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class URLScriptTriggerDescriptor
    extends TriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor());

        public ExecutorService getExecutor() {
            return this.queue.getExecutors();
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public URLTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            URLTrigger urlTrigger;
            String cronTabSpec = formData.getString("cronTabSpec");
            Object entryObject = formData.get("urlElements");
            ArrayList<URLTriggerEntry> entries = new ArrayList<URLTriggerEntry>();
            if (entryObject instanceof JSONObject) {
                entries.add(this.fillAndGetEntry(req, (JSONObject)entryObject));
            } else {
                JSONArray jsonArray = (JSONArray)entryObject;
                if (jsonArray != null) {
                    for (Object aJsonArray : jsonArray) {
                        entries.add(this.fillAndGetEntry(req, (JSONObject)aJsonArray));
                    }
                }
            }
            try {
                urlTrigger = new URLTrigger(cronTabSpec, entries);
            }
            catch (ANTLRException e) {
                throw new RuntimeException(e.getMessage());
            }
            return urlTrigger;
        }

        private URLTriggerEntry fillAndGetEntry(StaplerRequest req, JSONObject entryObject) {
            Object checkStatusObject;
            URLTriggerEntry urlTriggerEntry = new URLTriggerEntry();
            urlTriggerEntry.setUrl(entryObject.getString("url"));
            urlTriggerEntry.setProxyActivated(entryObject.getBoolean("proxyActivated"));
            String username = Util.fixEmpty((String)entryObject.getString("username"));
            if (username != null) {
                urlTriggerEntry.setUsername(username);
                Secret secret = Secret.fromString((String)Util.fixEmpty((String)entryObject.getString("password")));
                String encryptedValue = secret.getEncryptedValue();
                urlTriggerEntry.setPassword(encryptedValue);
            }
            if ((checkStatusObject = entryObject.get("checkStatus")) != null) {
                urlTriggerEntry.setCheckStatus(true);
                try {
                    JSONObject statusJSONObject = (JSONObject)checkStatusObject;
                    urlTriggerEntry.setStatusCode(statusJSONObject.getInt("statusCode"));
                }
                catch (JSONException jsne) {
                    urlTriggerEntry.setStatusCode(URLTriggerEntry.DEFAULT_STATUS_CODE);
                }
            } else {
                urlTriggerEntry.setCheckStatus(false);
                urlTriggerEntry.setStatusCode(URLTriggerEntry.DEFAULT_STATUS_CODE);
            }
            urlTriggerEntry.setCheckLastModificationDate(entryObject.getBoolean("checkLastModificationDate"));
            Object inspectingContentObject = entryObject.get("inspectingContent");
            if (inspectingContentObject == null) {
                urlTriggerEntry.setInspectingContent(false);
                urlTriggerEntry.setContentTypes(new URLTriggerContentType[0]);
            } else {
                JSONArray contentTypesJsonElt;
                urlTriggerEntry.setInspectingContent(true);
                JSONObject inspectingContentJSONObject = entryObject.getJSONObject("inspectingContent");
                try {
                    contentTypesJsonElt = inspectingContentJSONObject.getJSONArray("contentTypes");
                }
                catch (JSONException jsone) {
                    contentTypesJsonElt = inspectingContentJSONObject.getJSONObject("contentTypes");
                }
                List types = req.bindJSONToList(URLTriggerContentType.class, (Object)contentTypesJsonElt);
                urlTriggerEntry.setContentTypes(types.toArray(new URLTriggerContentType[types.size()]));
            }
            return urlTriggerEntry;
        }

        public String getDisplayName() {
            return Messages.urltrigger_displayName();
        }

        public String getHelpFile() {
            return "/plugin/urltrigger/help.html";
        }

        public DescriptorExtensionList getListURLTriggerDescriptors() {
            return DescriptorExtensionList.createDescriptorList((Hudson)Hudson.getInstance(), URLTriggerContentType.class);
        }

        public FormValidation doCheckStatus(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"You must provide a valid number status such as 200, 301, ...");
            }
        }

        public FormValidation doCheckURL(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"The url field is mandatory.");
            }
            try {
                DefaultClientConfig cc = new DefaultClientConfig();
                Client client = Client.create((ClientConfig)cc);
                client.resource(value).get(ClientResponse.class);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

