/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.model.Describable;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import io.jenkins.plugins.todeclarative.converter.api.BaseConverter;
import io.jenkins.plugins.todeclarative.converter.api.ConverterException;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.NoBuilderConverter;
import io.jenkins.plugins.todeclarative.converter.api.NoPublisherConverter;
import io.jenkins.plugins.todeclarative.converter.api.Warning;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;

public abstract class SingleTypedConverter<T>
extends BaseConverter {
    private final Class<T> type = Functions.getTypeParameter(this.getClass(), SingleTypedConverter.class, (int)0);

    protected SingleTypedConverter() {
    }

    @Override
    public boolean canConvert(@NonNull Object object) {
        return this.type.isInstance(object);
    }

    protected <T> void convertTypeList(ConverterRequest request, ConverterResult result, ExtensionList<BaseConverter> converterList, Collection<T> typeList) throws ConverterException {
        ModelASTStages stages = result.getModelASTPipelineDef().getStages();
        if (stages == null) {
            stages = new ModelASTStages((Object)this);
            result.getModelASTPipelineDef().setStages(stages);
        }
        for (T type : typeList) {
            boolean matched = false;
            for (BaseConverter converter : converterList) {
                if (!converter.canConvert(type)) continue;
                matched = true;
                if (converter.convert(request, result, type)) {
                    result.addConvertedType(type.getClass());
                }
                if (!(type instanceof Maven)) continue;
                break;
            }
            if (matched) continue;
            result.addWarning(new Warning("Converter not found '" + this.getDisplayName((Describable)type) + "'", type.getClass()));
            SingleTypedConverter noConverter = null;
            if (type instanceof Builder) {
                noConverter = (SingleTypedConverter)Jenkins.get().getExtensionList(NoBuilderConverter.class).get(0);
            } else if (type instanceof Publisher) {
                noConverter = (SingleTypedConverter)Jenkins.get().getExtensionList(NoPublisherConverter.class).get(0);
            }
            if (noConverter == null) continue;
            noConverter.convert(request, result, type);
        }
    }

    protected String getDisplayName(Describable describable) {
        try {
            return describable.getDescriptor() == null ? "" : describable.getDescriptor().getDisplayName();
        }
        catch (Throwable e) {
            return "";
        }
    }
}

