/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.util;

import hudson.Util;
import hudson.model.Run;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.TestNGResult;
import java.util.List;

public class TestResultHistoryUtil {
    private TestResultHistoryUtil() {
    }

    public static TestNGResult getPreviousBuildTestResults(Run<?, ?> owner) {
        Run previousBuild = owner.getPreviousCompletedBuild();
        if (previousBuild != null && previousBuild.getAction(TestNGTestResultBuildAction.class) != null) {
            return ((TestNGTestResultBuildAction)previousBuild.getAction(TestNGTestResultBuildAction.class)).getResult();
        }
        return new TestNGResult();
    }

    public static String toSummary(TestNGTestResultBuildAction action) {
        Run run = action.run;
        TestNGResult previousResult = TestResultHistoryUtil.getPreviousBuildTestResults(run);
        int prevFailedTestCount = previousResult.getFailCount();
        int prevSkippedTestCount = previousResult.getSkipCount();
        int prevFailedConfigurationCount = previousResult.getFailedConfigCount();
        int prevSkippedConfigurationCount = previousResult.getSkippedConfigCount();
        int prevTotalTestCount = previousResult.getTotalCount();
        TestNGResult tr = action.getResult();
        return "<ul>" + TestResultHistoryUtil.diff(prevTotalTestCount, tr.getTotalCount(), "Total Tests") + TestResultHistoryUtil.diff(prevFailedConfigurationCount, tr.getFailedConfigCount(), "Failed Configurations") + TestResultHistoryUtil.printTestsUrls(tr.getFailedConfigs()) + TestResultHistoryUtil.diff(prevFailedTestCount, tr.getFailCount(), "Failed Tests") + TestResultHistoryUtil.printTestsUrls((List<MethodResult>)tr.getFailedTests()) + TestResultHistoryUtil.diff(prevSkippedTestCount, tr.getSkipCount(), "Skipped Tests") + TestResultHistoryUtil.printTestsUrls((List<MethodResult>)tr.getSkippedTests()) + TestResultHistoryUtil.diff(prevSkippedConfigurationCount, tr.getSkippedConfigCount(), "Skipped Configurations") + TestResultHistoryUtil.printTestsUrls(tr.getSkippedConfigs()) + "</ul>";
    }

    private static String diff(long prev, long curr, String name) {
        if (prev == curr) {
            return "<li>" + name + ": " + curr + " (&plusmn;0)</li>";
        }
        if (prev < curr) {
            return "<li>" + name + ": " + curr + " (+" + (curr - prev) + ")</li>";
        }
        return "<li>" + name + ": " + curr + " (-" + (prev - curr) + ")</li>";
    }

    private static String printTestsUrls(List<MethodResult> methodResults) {
        StringBuilder htmlStr = new StringBuilder();
        htmlStr.append("<UL>");
        boolean firstGroup = true;
        String testName = "";
        String suiteName = "";
        int testIndex = 1;
        if (methodResults != null && methodResults.size() > 0) {
            for (MethodResult methodResult : methodResults) {
                if (!testName.equals(methodResult.getParentTestName()) || !suiteName.equals(methodResult.getParentSuiteName())) {
                    if (!firstGroup) {
                        htmlStr.append("</OL></LI>");
                    }
                    firstGroup = false;
                    testName = Util.escape((String)methodResult.getParentTestName());
                    suiteName = Util.escape((String)methodResult.getParentSuiteName());
                    htmlStr.append("<LI style=\"list-style-type:none\"><b>").append(suiteName).append(" / ").append(testName).append("</b>");
                    htmlStr.append("<OL start=\"").append(testIndex).append("\">");
                }
                htmlStr.append("<LI>");
                if (methodResult.getParent() instanceof ClassResult) {
                    htmlStr.append("<a href=\"").append(Util.escape((String)methodResult.getUpUrl()));
                    htmlStr.append("\">");
                    htmlStr.append(Util.escape((String)((ClassResult)methodResult.getParent()).getCanonicalName()));
                    htmlStr.append(".").append(Util.escape((String)methodResult.getName())).append("</a>");
                } else {
                    htmlStr.append(Util.escape((String)methodResult.getName()));
                }
                htmlStr.append("</LI>");
                ++testIndex;
            }
        }
        if (!firstGroup) {
            htmlStr.append("</OL></LI>");
        }
        htmlStr.append("</UL>");
        return htmlStr.toString();
    }
}

