/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.model.Run;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="BarRenderer subclasses do not seem to need to override it")
public class GraphHelper {
    private GraphHelper() {
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse2 rsp, StaplerRequest2 req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart createChart(final StaplerRequest2 req, CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Tests Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                String path = req.getParameter("rel");
                return (path == null ? "" : path) + label.getRun().getNumber() + "/testngreports/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                TestNGTestResultBuildAction report = (TestNGTestResultBuildAction)label.getRun().getAction(TestNGTestResultBuildAction.class);
                if (report == null) {
                    return "";
                }
                switch (row) {
                    case 0: {
                        return String.valueOf(report.getFailCount()) + " Failure(s)";
                    }
                    case 1: {
                        return String.valueOf(report.getTotalCount() - report.getFailCount() - report.getSkipCount()) + " Pass";
                    }
                    case 2: {
                        return String.valueOf(report.getSkipCount()) + " Skip(s)";
                    }
                }
                return "";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        ar.setSeriesPaint(2, (Paint)ColorPalette.YELLOW);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static JFreeChart createMethodChart(StaplerRequest2 req, final CategoryDataset dataset, final Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap, final String methodUrl) {
        JFreeChart chart = ChartFactory.createBarChart(null, null, (String)"Duration (secs)", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.removeLegend();
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer br = new BarRenderer(){
            Map<String, Paint> statusPaintMap = new HashMap<String, Paint>();
            {
                this.statusPaintMap.put("PASS", ColorPalette.BLUE);
                this.statusPaintMap.put("SKIP", ColorPalette.YELLOW);
                this.statusPaintMap.put("FAIL", ColorPalette.RED);
            }

            public Paint getItemPaint(int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                Paint paint = this.statusPaintMap.get(statusMap.get(label));
                return paint == null ? Color.gray : paint;
            }
        };
        br.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                if ("UNKNOWN".equals(statusMap.get(label))) {
                    return "unknown";
                }
                float value = dataset.getValue(row, column).floatValue();
                DecimalFormat df = new DecimalFormat("0.000");
                return df.format(value) + " secs";
            }
        });
        br.setBaseItemURLGenerator(new CategoryURLGenerator(){

            public String generateURL(CategoryDataset dataset, int series, int category) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(category);
                if ("UNKNOWN".equals(statusMap.get(label))) {
                    return null;
                }
                return GraphHelper.getUpUrl(label.getRun()) + label.getRun().getNumber() + methodUrl;
            }
        });
        br.setItemMargin(0.0);
        br.setMinimumBarLength(5.0);
        br.setBase(br.findRangeBounds(dataset).getUpperBound() / 100.0);
        plot.setRenderer((CategoryItemRenderer)br);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private static String getUpUrl(Run<?, ?> run) {
        return Functions.getNearestAncestorUrl((StaplerRequest2)Stapler.getCurrentRequest2(), (Object)run.getParent()) + "/";
    }
}

