/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.utility;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SumoLogHandler
extends Handler {
    private PluginDescriptorImpl pluginDescriptor;
    private Gson gson;
    private LogSenderHelper logSenderHelper;
    private LogRecordFormatter logRecordFormatter;
    private Level filterLevel = Level.parse(System.getProperty(SumoLogHandler.class.getName() + ".level", "INFO"));

    public static SumoLogHandler getInstance() {
        return new SumoLogHandler();
    }

    public SumoLogHandler() {
        this.pluginDescriptor = PluginDescriptorImpl.getInstance();
        this.gson = new Gson();
        this.logRecordFormatter = new LogRecordFormatter();
        this.setFilter(new LogRecordFilter());
        this.setLevel(this.filterLevel);
        this.logSenderHelper = LogSenderHelper.getInstance();
    }

    @Override
    public void publish(LogRecord record) {
        try {
            if (!this.pluginDescriptor.isHandlerStarted()) {
                return;
            }
            if (!this.isLoggable(record)) {
                return;
            }
            if (this.pluginDescriptor.isPeriodicLogEnabled()) {
                String message = this.logRecordFormatter.formatRecord(record);
                this.logSenderHelper.sendLogsToPeriodicSourceCategory(message);
            }
        }
        catch (Exception exception) {
            Logger.getLogger("").removeHandler(SumoLogHandler.getInstance());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static class LogRecordFilter
    implements Filter {
        private LogRecordFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String logSource = record.getSourceClassName();
            String loggerName = record.getLoggerName();
            if (logSource == null || loggerName == null) {
                return false;
            }
            for (String name : SumoConstants.skipLoggerNames) {
                if (!loggerName.startsWith(name) && !logSource.startsWith(name)) continue;
                return false;
            }
            if (record.getThrown() != null) {
                StackTraceElement[] cause;
                for (StackTraceElement element : cause = record.getThrown().getStackTrace()) {
                    if (!element.getClassName().equals(SumoLogHandler.class.getName())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private class LogRecordFormatter
    extends Formatter {
        private LogRecordFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return this.formatMessage(record);
        }

        private String formatRecord(LogRecord record) {
            HashMap<String, Object> logMessage = new HashMap<String, Object>();
            logMessage.put("threadId", record.getThreadID());
            logMessage.put("logType", LogTypeEnum.JENKINS_LOG.getValue());
            logMessage.put("eventTime", SumoConstants.DATETIME_FORMATTER.format(new Date()));
            logMessage.put("logLevel", record.getLevel().getName());
            logMessage.put("logMessage", this.formatMessage(record));
            logMessage.put("logSource", record.getLoggerName());
            if (record.getLevel().intValue() > Level.INFO.intValue() && record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                logMessage.put("logStackTrace", sw.toString());
            }
            return SumoLogHandler.this.gson.toJson(logMessage);
        }
    }
}

