/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sender;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.PipelineStageModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.TestCaseModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.TestCaseResultModel;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSender;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class LogSenderHelper {
    public static final Logger LOG = Logger.getLogger(LogSenderHelper.class.getName());

    public LogSenderHelper() {
        LOG.log(Level.INFO, "Initialized the Log Sender Helper");
    }

    public static LogSenderHelper getInstance() {
        return LogSenderHelperHolder.logSenderHelper;
    }

    public void sendData(byte[] bytes) {
        LogSender.getInstance().sendLogs(bytes);
    }

    public void sendDataWithFields(byte[] bytes, HashMap<String, String> fields) {
        LogSender.getInstance().sendLogs(bytes, null, fields);
    }

    public void sendLogsToPeriodicSourceCategory(String data) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            LogSender.getInstance().sendLogs(data.getBytes());
        }
    }

    public void sendMultiplePeriodicLogs(List<String> messages) {
        List<String> strings = LogSenderHelper.divideDataIntoEquals(messages);
        for (String data : strings) {
            this.sendLogsToPeriodicSourceCategory(data);
        }
    }

    public void sendFilesData(List<String> messages, String localFileString, HashMap<String, String> fields) {
        if (CollectionUtils.isNotEmpty(messages)) {
            List<String> strings = LogSenderHelper.divideDataIntoEquals(messages);
            for (String data : strings) {
                LogSender.getInstance().sendLogs(data.getBytes(), localFileString, fields);
            }
        }
    }

    public void sendLogsToMetricDataCategory(List<String> messages) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isMetricDataEnabled()) {
            List<String> strings = LogSenderHelper.divideDataIntoEquals(messages);
            for (String data : strings) {
                LogSender.getInstance().sendLogs(data.getBytes(), null, "application/vnd.sumologic.graphite");
            }
        }
    }

    public void sendJobStatusLogs(String data) {
        LogSender.getInstance().sendLogs(data.getBytes());
    }

    public void sendConsoleLogs(String data, String jobName, int buildNumber, String stageName) {
        String sourceName = jobName + "#" + buildNumber;
        if (StringUtils.isNotEmpty((String)stageName)) {
            sourceName = sourceName + "#" + stageName;
        }
        LogSender.getInstance().sendLogs(data.getBytes(), sourceName);
    }

    public void sendAuditLogs(String data) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            LogSender.getInstance().sendLogs(data.getBytes());
        }
    }

    private static List<String> divideDataIntoEquals(List<String> messages) {
        ArrayList<String> convertedMessages = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int count = 1;
        for (String message : messages) {
            stringBuilder.append(message).append("\n");
            if (count % 100 == 0) {
                convertedMessages.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            }
            ++count;
        }
        convertedMessages.add(stringBuilder.toString());
        return convertedMessages;
    }

    public static void sendTestResult(TestCaseModel testCaseModel, BuildModel buildModel) {
        Gson gson = new Gson();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logType", LogTypeEnum.TEST_RESULT.getValue());
        data.put("name", buildModel.getName());
        data.put("number", buildModel.getNumber());
        if (testCaseModel != null && CollectionUtils.isNotEmpty(testCaseModel.getTestResults())) {
            List<TestCaseResultModel> testResults = testCaseModel.getTestResults();
            LinkedList<TestCaseResultModel> toBeSent = new LinkedList<TestCaseResultModel>();
            data.put("testResult", toBeSent);
            int size = gson.toJson(data).getBytes().length;
            for (TestCaseResultModel testCaseResultModel : testResults) {
                if ("Failed".equals(testCaseResultModel.getStatus())) {
                    testCaseResultModel.setErrorDetails(LogSenderHelper.format(testCaseResultModel.getErrorDetails()));
                    testCaseResultModel.setErrorStackTrace(LogSenderHelper.format(testCaseResultModel.getErrorStackTrace()));
                }
                if ((size += gson.toJson((Object)testCaseResultModel).getBytes().length) > 50000) {
                    LogSenderHelper.sendTestResultInChunksOfPreDefinedSize(buildModel, gson, toBeSent, data);
                    toBeSent.clear();
                }
                toBeSent.add(testCaseResultModel);
                size = gson.toJson(data).getBytes().length;
            }
            if (CollectionUtils.isNotEmpty(toBeSent)) {
                LogSenderHelper.sendTestResultInChunksOfPreDefinedSize(buildModel, gson, toBeSent, data);
                toBeSent.clear();
            }
        }
    }

    private static void sendTestResultInChunksOfPreDefinedSize(BuildModel buildModel, Gson gson, List<TestCaseResultModel> toBeSent, Map<String, Object> data) {
        LOG.log(Level.INFO, "Job Name - " + buildModel.getName() + ", Build Number - " + buildModel.getNumber() + ", test result count is " + toBeSent.size() + ", number of bytes is " + gson.toJson(data).getBytes().length);
        LogSender.getInstance().sendLogs(gson.toJson(data).getBytes());
    }

    public static void sendPipelineStages(List<PipelineStageModel> stages, BuildModel buildModel) {
        ArrayList<String> allStages = new ArrayList<String>();
        Gson gson = new Gson();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logType", LogTypeEnum.PIPELINE_STAGES.getValue());
        data.put("name", buildModel.getName());
        data.put("number", buildModel.getNumber());
        data.put("result", buildModel.getResult());
        data.put("jobStartTime", buildModel.getJobStartTime());
        data.put("jobType", buildModel.getJobType());
        data.put("jobRunDuration", Float.valueOf(buildModel.getJobRunDuration()));
        data.put("jobBuildURL", buildModel.getJobBuildURL());
        data.put("upstreamJobURL", buildModel.getUpstreamJobURL());
        if (CollectionUtils.isNotEmpty(stages)) {
            for (PipelineStageModel pipelineStageModel : stages) {
                data.put("stages", new ArrayList<PipelineStageModel>(Collections.singletonList(pipelineStageModel)));
                allStages.add(gson.toJson(data));
            }
        }
        List<String> strings = LogSenderHelper.divideDataIntoEquals(allStages);
        for (String value : strings) {
            LogSenderHelper.sendStagesInChunksOfPreDefinedSize(buildModel, allStages, value);
        }
    }

    private static void sendStagesInChunksOfPreDefinedSize(BuildModel buildModel, List<String> toBeSent, String data) {
        LOG.log(Level.INFO, "Job Name - " + buildModel.getName() + ", Build Number - " + buildModel.getNumber() + ", Stage count is " + toBeSent.size() + ", number of bytes is " + data.length());
        LogSender.getInstance().sendLogs(data.getBytes());
    }

    private static String format(String data) {
        if (StringUtils.isNotEmpty((String)data)) {
            data = data.replace("{", "(");
            return data.replace("}", ")");
        }
        return null;
    }

    private static class LogSenderHelperHolder {
        public static LogSenderHelper logSenderHelper = new LogSenderHelper();

        private LogSenderHelperHolder() {
        }
    }
}

