/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sender;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.model.PluginConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class LogSender {
    public static final Logger LOG = Logger.getLogger(LogSender.class.getName());
    CloseableHttpClient httpclient;
    RequestConfig proxyConfig;
    boolean enableProxy;
    boolean enableProxyAuth;

    private LogSender() {
        LOG.log(Level.INFO, "Initializing Log Sender to Send Logs to Sumo Logic.");
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(-1L, TimeUnit.MINUTES);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(20);
        SocketConfig defaultSocketConfig = SocketConfig.custom().setSoTimeout((int)TimeUnit.MINUTES.toMillis(3L)).build();
        connectionManager.setDefaultSocketConfig(defaultSocketConfig);
        DefaultConnectionKeepAliveStrategy myStrategy = new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                long keepAliveTime = super.getKeepAliveDuration(httpResponse, httpContext);
                if (keepAliveTime == -1L) {
                    keepAliveTime = TimeUnit.MINUTES.toMillis(2L);
                }
                return keepAliveTime;
            }
        };
        PluginConfiguration pluginConfig = PluginDescriptorImpl.getPluginConfiguration();
        this.enableProxy = pluginConfig.isEnableProxy();
        this.enableProxyAuth = pluginConfig.isEnableProxyAuth();
        BasicCredentialsProvider credsProvider = null;
        if (this.enableProxy) {
            String proxyHost = pluginConfig.getProxyHost();
            int proxyPort = pluginConfig.getProxyPort();
            if (this.enableProxyAuth) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                String proxyAuthUsername = pluginConfig.getProxyAuthUsername();
                String proxyAuthPassword = pluginConfig.getProxyAuthPassword();
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxyAuthUsername, proxyAuthPassword);
                credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(authScope, (Credentials)creds);
            }
            HttpHost pHost = new HttpHost(proxyHost, proxyPort, "http");
            RequestConfig.Builder reqconfigconbuilder = RequestConfig.custom();
            reqconfigconbuilder = reqconfigconbuilder.setProxy(pHost);
            this.proxyConfig = reqconfigconbuilder.build();
        }
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)myStrategy).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).useSystemProperties().setDefaultCredentialsProvider(credsProvider).build();
    }

    private String getHost(PluginConfiguration pluginConfiguration) {
        String hostName = "unknown";
        try {
            hostName = pluginConfiguration.getMetricDataPrefix() != null ? pluginConfiguration.getMetricDataPrefix() : InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Couldn't resolve jenkins host name... Using unknown.");
        }
        return hostName;
    }

    public static LogSender getInstance() {
        return LogSenderHolder.logSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendLogs(byte[] msg, String sumoName, String contentType, HashMap<String, String> fields) {
        HttpPost post = null;
        CloseableHttpResponse response = null;
        PluginConfiguration pluginConfiguration = PluginDescriptorImpl.getPluginConfiguration();
        try {
            post = new HttpPost(pluginConfiguration.getSumoLogicEndpoint());
            if (this.enableProxy) {
                post.setConfig(this.proxyConfig);
            }
            this.createHeaders(post, sumoName, contentType, fields, pluginConfiguration);
            byte[] compressedData = this.compress(msg);
            post.setEntity((HttpEntity)new ByteArrayEntity(compressedData));
            response = this.httpclient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() != 200) {
                LOG.log(Level.WARNING, String.format("Received HTTP error from Sumo Service: %d", statusLine.getStatusCode()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, String.format("Could not send log to Sumo Logic: %s", e.toString()));
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unable to Close Response");
                }
            }
        }
    }

    public void sendLogs(byte[] msg) {
        this.sendLogs(msg, null, null, null);
    }

    public void sendLogs(byte[] msg, String sumoName) {
        this.sendLogs(msg, sumoName, null, null);
    }

    public void sendLogs(byte[] msg, String sumoName, String contentType) {
        this.sendLogs(msg, sumoName, contentType, null);
    }

    public void sendLogs(byte[] msg, String sumoName, HashMap<String, String> fields) {
        this.sendLogs(msg, sumoName, null, fields);
    }

    private byte[] compress(byte[] content) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(content);
        gzipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void createHeaders(HttpPost post, String sumoName, String contentType, HashMap<String, String> fields, PluginConfiguration pluginConfiguration) {
        post.addHeader("X-Sumo-Host", this.getHost(pluginConfiguration));
        if (StringUtils.isNotBlank((String)sumoName)) {
            post.addHeader("X-Sumo-Name", sumoName);
        }
        post.addHeader("X-Sumo-Category", pluginConfiguration.getSourceCategory());
        post.addHeader("Content-Encoding", "gzip");
        if (this.isValidContentType(contentType)) {
            post.addHeader("Content-Type", contentType);
        }
        if (fields != null && !fields.isEmpty()) {
            String field_string = fields.keySet().stream().map(key -> key + "=" + (String)fields.get(key)).collect(Collectors.joining(","));
            post.addHeader("X-Sumo-Fields", field_string);
        }
        post.addHeader("X-Sumo-Client", "sumologic-jenkins-plugin");
    }

    private boolean isValidContentType(String contentType) {
        if (contentType != null) {
            return "application/vnd.sumologic.graphite".equals(contentType) || "application/vnd.sumologic.carbon2".equals(contentType);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine testHTTPUrl(String url) throws Exception {
        HttpPost post = null;
        CloseableHttpResponse response = null;
        try {
            post = new HttpPost(url);
            if (this.enableProxy) {
                post.setConfig(this.proxyConfig);
            }
            post.setEntity((HttpEntity)new StringEntity("This is a Test Message from Jenkins Plugin."));
            response = this.httpclient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            return statusLine;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unable to Close Response");
                }
            }
        }
    }

    private static class LogSenderHolder {
        static LogSender logSender = new LogSender();

        private LogSenderHolder() {
        }
    }
}

