/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.pipeline;

import com.cloudbees.workflow.rest.external.ErrorExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.PipelineStageModel;
import com.sumologic.jenkins.jenkinssumologicplugin.pipeline.ExecutionNodeExtractor;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.model.Result;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LabelledChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "RV_RETURN_VALUE_IGNORED"})
public class PipelineStageViewExtractor {
    private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();
    private static final Logger LOG = Logger.getLogger(PipelineStageViewExtractor.class.getName());

    public static void extractPipelineStages(WorkflowRun workflowRun, BuildModel buildModel) {
        ArrayList<PipelineStageModel> pipelineStageModels = new ArrayList<PipelineStageModel>();
        RunExt runExt = RunExt.create((WorkflowRun)workflowRun);
        FlowExecution execution = workflowRun.getExecution();
        ExecutionNodeExtractor visitor = new ExecutionNodeExtractor(workflowRun);
        if (execution != null) {
            ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new LabelledChunkFinder());
        }
        if (Objects.nonNull(runExt) && CollectionUtils.isNotEmpty((Collection)runExt.getStages())) {
            for (StageNodeExt stageNodeExt : runExt.getStages()) {
                ArrayList<String> steps = new ArrayList<String>();
                PipelineStageModel pipelineStageModel2 = PipelineStageViewExtractor.setStageDetails((FlowNodeExt)stageNodeExt, visitor.getWorkspaceNodes());
                List stageFlowNodes = stageNodeExt.getStageFlowNodes();
                if (CollectionUtils.isNotEmpty((Collection)stageFlowNodes)) {
                    stageFlowNodes.forEach(atomFlowNodeExt -> {
                        String data = PipelineStageViewExtractor.setStepDetails((FlowNodeExt)atomFlowNodeExt, visitor.getWorkspaceNodes());
                        if (StringUtils.isNotBlank((String)data)) {
                            steps.add(data);
                        }
                    });
                    if (CollectionUtils.isNotEmpty(steps)) {
                        pipelineStageModel2.setSteps(steps);
                    }
                }
                if (visitor.getParallelNodes().containsKey(stageNodeExt.getId())) {
                    pipelineStageModel2.setParallelStage(visitor.getParallelNodes().get(stageNodeExt.getId()));
                }
                pipelineStageModels.add(pipelineStageModel2);
            }
        }
        AtomicInteger counter = new AtomicInteger(1);
        pipelineStageModels.forEach(pipelineStageModel -> pipelineStageModel.setId(counter.getAndIncrement()));
        if (CollectionUtils.isNotEmpty(pipelineStageModels)) {
            LogSenderHelper.sendPipelineStages(pipelineStageModels, buildModel);
        }
    }

    private static PipelineStageModel setStageDetails(FlowNodeExt stageExt, Map<String, String> executionNodes) {
        PipelineStageModel pipelineStageDTO = new PipelineStageModel();
        pipelineStageDTO.setStageId(stageExt.getId());
        pipelineStageDTO.setName(stageExt.getName());
        pipelineStageDTO.setStatus(PipelineStageViewExtractor.convertToResult(stageExt.getStatus()));
        pipelineStageDTO.setStartTime(SumoConstants.DATETIME_FORMATTER.format(stageExt.getStartTimeMillis()));
        pipelineStageDTO.setDuration((float)stageExt.getDurationMillis() / 1000.0f);
        pipelineStageDTO.setPauseDuration((float)stageExt.getPauseDurationMillis() / 1000.0f);
        pipelineStageDTO.setArguments(stageExt.getParameterDescription());
        pipelineStageDTO.setExecutionNode(executionNodes.getOrDefault(stageExt.getId(), "(master)"));
        ErrorExt error = stageExt.getError();
        if (error != null) {
            Object errorMessage = "StageErrorType - " + error.getType() + ",StageErrorMessage - " + error.getMessage();
            errorMessage = ((String)errorMessage).replace("{", "(");
            errorMessage = ((String)errorMessage).replace("}", ")");
            pipelineStageDTO.setError((String)errorMessage);
        }
        return pipelineStageDTO;
    }

    private static String setStepDetails(FlowNodeExt stepExt, Map<String, String> executionNodes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StepName - ").append(stepExt.getName()).append(",").append("StepStatus - ").append(PipelineStageViewExtractor.convertToResult(stepExt.getStatus())).append(",").append("StepDuration - ").append((float)stepExt.getDurationMillis() / 1000.0f).append(",").append("StepArguments - ").append(stepExt.getParameterDescription()).append(",").append("StepExecutedOn - ").append(executionNodes.getOrDefault(stepExt.getId(), "(master)"));
        ErrorExt error = stepExt.getError();
        if (error != null) {
            stringBuilder.append(",StepErrorType - ").append(error.getType()).append(",").append("StepErrorMessage - ").append(error.getMessage());
        }
        stringBuilder.append(",StepPauseDuration - ").append((float)stepExt.getPauseDurationMillis() / 1000.0f).append(",").append("StepId - ").append(stepExt.getId());
        String step = stringBuilder.toString();
        step = step.replace("{", "(");
        step = step.replace("}", ")");
        return step;
    }

    private static String convertToResult(StatusExt status) {
        if (status == null) {
            return "UNKNOWN";
        }
        switch (status) {
            case FAILED: {
                return Result.FAILURE.toString();
            }
            case NOT_EXECUTED: {
                return Result.NOT_BUILT.toString();
            }
        }
        return status.toString();
    }

    public static void extractConsoleLogs(WorkflowRun workflowRun) {
        FlowExecution execution = workflowRun.getExecution();
        ExecutionNodeExtractor visitor = new ExecutionNodeExtractor(workflowRun);
        if (execution != null) {
            ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new LabelledChunkFinder());
        }
        Map<String, String> nodeWithNames = visitor.getStages().stream().filter(stageNodeExt -> !stageNodeExt.getStatus().equals((Object)StatusExt.NOT_EXECUTED)).collect(Collectors.toMap(FlowNodeExt::getId, FlowNodeExt::getName));
        HashMap<String, Set> logsNodeWise = new HashMap<String, Set>();
        FlowExecution exec = workflowRun.getExecution();
        if (exec != null) {
            FlowGraphWalker walker = new FlowGraphWalker(exec);
            for (FlowNode node : walker) {
                try {
                    ErrorAction error;
                    LogAction action = (LogAction)node.getAction(LogAction.class);
                    LinkedHashSet<String> messages2 = new LinkedHashSet<String>();
                    if (action != null && action.getLogText() != null) {
                        AnnotatedLargeText logText = action.getLogText();
                        StringWriter writer = new StringWriter();
                        logText.writeLogTo(0L, (Writer)writer);
                        if (StringUtils.isNotEmpty((String)writer.toString())) {
                            messages2.add(writer.toString());
                        }
                        writer.close();
                    }
                    if ((error = node.getError()) != null) {
                        Throwable throwable = error.getError();
                        messages2.add(throwable.getMessage());
                    }
                    String nodeName2 = PipelineStageViewExtractor.getLogPrefix(node, nodeWithNames);
                    if (!CollectionUtils.isNotEmpty(messages2)) continue;
                    if (logsNodeWise.containsKey(nodeName2)) {
                        ((Set)logsNodeWise.get(nodeName2)).addAll(messages2);
                        continue;
                    }
                    logsNodeWise.put(nodeName2, messages2);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error Sending console Logs", e);
                }
            }
            logsNodeWise.forEach((nodeName, messages) -> {
                StringBuilder stringBuilder = new StringBuilder();
                messages.forEach(s -> stringBuilder.append("[").append(SumoConstants.DATETIME_FORMATTER.format(new Date())).append("] ").append(" ").append((String)s).append("\n"));
                logSenderHelper.sendConsoleLogs(stringBuilder.toString(), ((WorkflowJob)workflowRun.getParent()).getFullName(), workflowRun.getNumber(), (String)nodeName);
            });
        }
    }

    private static String getLogPrefix(FlowNode node, Map<String, String> nodeWithNames) {
        if (nodeWithNames.containsKey(node.getId())) {
            return nodeWithNames.get(node.getId());
        }
        for (FlowNode parentNode : node.getParents()) {
            String prefix = PipelineStageViewExtractor.getLogPrefix(parentNode, nodeWithNames);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }
}

