/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.model.ScmModel;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class SumoSCMListener
extends SCMListener {
    private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();
    private static final Logger LOG = Logger.getLogger(SumoSCMListener.class.getName());

    public void onChangeLogParsed(Run<?, ?> build, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) {
        try {
            PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
            if (!pluginDescriptor.isScmLogEnabled()) {
                return;
            }
            ScmModel scmModel = new ScmModel();
            scmModel.setLogType(LogTypeEnum.SCM_STATUS.getValue());
            scmModel.setEventTime(SumoConstants.DATETIME_FORMATTER.format(new Date()));
            scmModel.setJobName(build.getParent().getFullName());
            scmModel.setBuildNumber(build.getNumber());
            ArrayList<String> changes = new ArrayList<String>();
            for (ChangeLogSet.Entry entry : changelog) {
                String sbr = entry.getTimestamp() + " commit:" + entry.getCommitId() + " author:" + String.valueOf(entry.getAuthor()) + " message:" + entry.getMsg();
                changes.add(sbr);
            }
            scmModel.setChangeLog(changes);
            this.populateGitScmDetails(scm, scmModel, build);
            this.populateSubversionDetails(scm, scmModel);
            if (pluginDescriptor.isScmLogEnabled()) {
                logSenderHelper.sendJobStatusLogs(scmModel.toString());
            }
        }
        catch (Exception exception) {
            String errorMessage = "Job SCM Logs Sender ended with exception as " + exception.getMessage();
            LOG.log(Level.WARNING, errorMessage, exception);
            listener.error(errorMessage);
        }
    }

    private void populateGitScmDetails(SCM scm, ScmModel scmModel, Run<?, ?> build) {
        if (scm instanceof GitSCM) {
            Revision rev;
            GitSCM gitSCM = (GitSCM)scm;
            scmModel.setScmType(gitSCM.getType());
            scmModel.setScmURLs(gitSCM.getKey());
            BuildData buildData = gitSCM.getBuildData(build);
            if (buildData != null && (rev = buildData.getLastBuiltRevision()) != null) {
                String sha1 = Util.fixEmpty((String)rev.getSha1String());
                if (sha1 != null && !sha1.isEmpty()) {
                    scmModel.setRevision(sha1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                rev.getBranches().forEach(branch -> {
                    String branchName = this.getBranchName((Branch)branch);
                    stringBuilder.append(branchName).append(" ");
                });
                scmModel.setBranches(stringBuilder.toString());
            }
        }
    }

    private void populateSubversionDetails(SCM scm, ScmModel scmModel) {
        if (scm instanceof SubversionSCM) {
            SubversionSCM subversionSCM = (SubversionSCM)scm;
            scmModel.setScmType(subversionSCM.getType());
            scmModel.setScmURLs(subversionSCM.getKey());
        }
    }

    private String getBranchName(Branch branch) {
        String name = branch.getName();
        if (name.startsWith("refs/remotes/")) {
            name = name.substring("refs/remotes/".length());
        }
        return name;
    }
}

