/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.EventSourceEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Extension
public class SumoJenkinsComputerListener
extends ComputerListener {
    public void preLaunch(Computer computer, TaskListener listener) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_PRE_LAUNCH.getValue());
            listener.getLogger().flush();
        }
    }

    public void preOnline(Computer computer, Channel channel, FilePath root, TaskListener listener) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_PRE_ONLINE.getValue());
            listener.getLogger().flush();
        }
    }

    public void onOnline(Computer computer, TaskListener listener) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_ONLINE.getValue());
            listener.getLogger().flush();
        }
    }

    public void onOffline(@Nonnull Computer computer, @CheckForNull OfflineCause cause) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_OFFLINE.getValue());
        }
    }

    public void onTemporarilyOnline(Computer computer) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_TEMP_ONLINE.getValue());
        }
    }

    public void onTemporarilyOffline(Computer computer, OfflineCause cause) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.COMPUTER_TEMP_OFFLINE.getValue());
        }
    }

    public void onLaunchFailure(Computer computer, TaskListener taskListener) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isPeriodicLogEnabled()) {
            CommonModelFactory.updateStatus(computer, EventSourceEnum.LAUNCH_FAILURE.getValue());
            taskListener.getLogger().flush();
        }
    }
}

