/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.AuditEventTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;

@Extension
public class SumoItemListener
extends ItemListener {
    public void onCreated(Item item) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.CREATED, this.getItemName(item), null);
        }
    }

    public void onCopied(Item src, Item item) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.UPDATED, this.getItemName(item), this.getItemName(src));
        }
    }

    public void onDeleted(Item item) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.DELETED, this.getItemName(item), null);
        }
    }

    public void onUpdated(Item item) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.UPDATED, this.getItemName(item), null);
        }
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.UPDATED, oldFullName, newFullName);
        }
    }

    public void onBeforeShutdown() {
    }

    private String getItemName(Item item) {
        if (item == null) {
            return "unknown";
        }
        return item.getName();
    }
}

