/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.SumoBuildNotifier;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.EventSourceEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.metrics.SumoMetricDataPublisher;
import com.sumologic.jenkins.jenkinssumologicplugin.model.PluginConfiguration;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSender;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.SumoLogHandler;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.TermMilestone;
import hudson.init.Terminator;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.StatusLine;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public final class PluginDescriptorImpl
extends BuildStepDescriptor<Publisher> {
    private boolean enableProxy = false;
    private String proxyHost = "";
    private int proxyPort = -1;
    private boolean enableProxyAuth = false;
    private String proxyAuthUsername = "";
    private String proxyAuthPassword = "";
    private Secret url;
    private transient SumoMetricDataPublisher sumoMetricDataPublisher;
    private static LogSenderHelper logSenderHelper = null;
    private String queryPortal;
    private String sourceCategory;
    private String metricDataPrefix;
    private boolean auditLogEnabled;
    private boolean keepOldConfigData;
    private boolean metricDataEnabled;
    private boolean periodicLogEnabled;
    private boolean jobStatusLogEnabled;
    private boolean jobConsoleLogEnabled;
    private boolean scmLogEnabled;
    private boolean isHandlerStarted;

    public PluginDescriptorImpl() {
        super(SumoBuildNotifier.class);
        this.load();
        this.sumoMetricDataPublisher = new SumoMetricDataPublisher();
        if (this.metricDataEnabled && this.metricDataPrefix != null) {
            this.getSumoMetricDataPublisher().stopReporter();
            this.getSumoMetricDataPublisher().publishMetricData(this.metricDataPrefix);
        }
        if (!this.metricDataEnabled) {
            this.getSumoMetricDataPublisher().stopReporter();
        }
        PluginDescriptorImpl.setLogSenderHelper(LogSenderHelper.getInstance());
    }

    private static void setLogSenderHelper(LogSenderHelper logSenderHelper) {
        PluginDescriptorImpl.logSenderHelper = logSenderHelper;
    }

    public static PluginDescriptorImpl getInstance() {
        return (PluginDescriptorImpl)Jenkins.get().getDescriptor(SumoBuildNotifier.class);
    }

    public static PluginConfiguration getPluginConfiguration() {
        Channel channel = Channel.current();
        if (channel != null) {
            try {
                return (PluginConfiguration)channel.call((Callable)new PluginConfigurationFromMain());
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        PluginDescriptorImpl pluginDescriptor = (PluginDescriptorImpl)Jenkins.get().getDescriptor(SumoBuildNotifier.class);
        assert (pluginDescriptor != null);
        return new PluginConfiguration(pluginDescriptor);
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Sumo Logic build logger";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        boolean configOk = super.configure(req, formData);
        this.url = Secret.fromString((String)formData.getString("url"));
        this.queryPortal = StringUtils.isNotEmpty((String)formData.getString("queryPortal")) ? formData.getString("queryPortal") : "service.sumologic.com";
        this.enableProxy = formData.getBoolean("enableProxy");
        this.proxyHost = formData.getString("proxyHost");
        this.proxyPort = Integer.parseInt(formData.getString("proxyPort"));
        this.enableProxyAuth = formData.getBoolean("enableProxyAuth");
        this.proxyAuthUsername = formData.getString("proxyAuthUsername");
        this.proxyAuthPassword = formData.getString("proxyAuthPassword");
        this.sourceCategory = StringUtils.isNotEmpty((String)formData.getString("sourceCategory")) ? formData.getString("sourceCategory") : "jenkinsSourceCategory";
        this.metricDataPrefix = StringUtils.isNotEmpty((String)formData.getString("metricDataPrefix")) ? formData.getString("metricDataPrefix") : "jenkinsMetricDataPrefix";
        this.auditLogEnabled = formData.getBoolean("auditLogEnabled");
        this.metricDataEnabled = formData.getBoolean("metricDataEnabled");
        this.periodicLogEnabled = formData.getBoolean("periodicLogEnabled");
        this.jobStatusLogEnabled = formData.getBoolean("jobStatusLogEnabled");
        this.jobConsoleLogEnabled = formData.getBoolean("jobConsoleLogEnabled");
        this.scmLogEnabled = formData.getBoolean("scmLogEnabled");
        this.keepOldConfigData = formData.getBoolean("keepOldConfigData");
        this.save();
        if (this.metricDataEnabled && this.metricDataPrefix != null) {
            this.getSumoMetricDataPublisher().stopReporter();
            this.getSumoMetricDataPublisher().publishMetricData(this.metricDataPrefix);
        }
        if (!this.metricDataEnabled) {
            this.getSumoMetricDataPublisher().stopReporter();
        }
        return configOk;
    }

    @Terminator(after=TermMilestone.STARTED)
    @Restricted(value={NoExternalUse.class})
    public static void shutdown() {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.checkIfPluginInUse();
        pluginDescriptor.getSumoMetricDataPublisher().stopReporter();
        Logger.getLogger("").removeHandler(SumoLogHandler.getInstance());
        HashMap<String, String> shutDown = new HashMap<String, String>();
        shutDown.put("logType", LogTypeEnum.AGENT_EVENT.getValue());
        shutDown.put("eventTime", SumoConstants.DATETIME_FORMATTER.format(new Date()));
        shutDown.put("eventSource", EventSourceEnum.SHUTDOWN.getValue());
        Gson gson = new Gson();
        logSenderHelper.sendLogsToPeriodicSourceCategory(gson.toJson(shutDown));
    }

    private static PluginDescriptorImpl checkIfPluginInUse() {
        PluginDescriptorImpl pluginDescriptor = (PluginDescriptorImpl)((Object)ExtensionList.lookup(BuildStepDescriptor.class).get(PluginDescriptorImpl.class));
        if (pluginDescriptor == null) {
            throw new IllegalStateException("Sumo Logic Publisher is not part of the extension list");
        }
        return pluginDescriptor;
    }

    public FormValidation doCheckUrl(@QueryParameter String value) {
        if (value.isEmpty()) {
            return FormValidation.error((String)"You must provide an URL.");
        }
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"This is not a valid URL.");
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doTestURL(@QueryParameter(value="url") String url) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            URL parsedUrl = new URL(url);
            String host = parsedUrl.getHost();
            if (host == null) {
                return FormValidation.error((String)"Host cannot be null.");
            }
            if (!(host = host.toLowerCase()).endsWith(".sumologic.com") && !host.endsWith(".sumologic.net")) {
                return FormValidation.error((String)"This URL is not allowed.");
            }
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"This is not a valid URL.");
        }
        try {
            StatusLine statusLine = LogSender.getInstance().testHTTPUrl(url);
            if (200 == statusLine.getStatusCode()) {
                return FormValidation.ok((String)"Success");
            }
            return FormValidation.error((String)("URL not valid with message " + statusLine.getReasonPhrase()));
        }
        catch (Exception e) {
            return FormValidation.error((String)("Failure : " + e.getMessage()));
        }
    }

    public SumoMetricDataPublisher getSumoMetricDataPublisher() {
        return this.sumoMetricDataPublisher;
    }

    public void setSumoMetricDataPublisher(SumoMetricDataPublisher sumoMetricDataPublisher) {
        this.sumoMetricDataPublisher = sumoMetricDataPublisher;
    }

    public String getQueryPortal() {
        return this.queryPortal;
    }

    public void setQueryPortal(String queryPortal) {
        this.queryPortal = queryPortal;
    }

    public boolean isAuditLogEnabled() {
        return this.auditLogEnabled;
    }

    public void setAuditLogEnabled(boolean auditLogEnabled) {
        this.auditLogEnabled = auditLogEnabled;
    }

    public boolean isMetricDataEnabled() {
        return this.metricDataEnabled;
    }

    public void setMetricDataEnabled(boolean metricDataEnabled) {
        this.metricDataEnabled = metricDataEnabled;
    }

    public boolean isPeriodicLogEnabled() {
        return this.periodicLogEnabled;
    }

    public void setPeriodicLogEnabled(boolean periodicLogEnabled) {
        this.periodicLogEnabled = periodicLogEnabled;
    }

    public boolean isJobStatusLogEnabled() {
        return this.jobStatusLogEnabled;
    }

    public void setJobStatusLogEnabled(boolean jobStatusLogEnabled) {
        this.jobStatusLogEnabled = jobStatusLogEnabled;
    }

    public boolean getEnableProxy() {
        return this.enableProxy;
    }

    public void setEnableProxy(boolean enableProxy) {
        this.enableProxy = enableProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean getEnableProxyAuth() {
        return this.enableProxyAuth;
    }

    public void setEnableProxyAuth(boolean enableProxyAuth) {
        this.enableProxyAuth = enableProxyAuth;
    }

    public String getProxyAuthUsername() {
        return this.proxyAuthUsername;
    }

    public void setProxyAuthUsername(String proxyAuthUsername) {
        this.proxyAuthUsername = proxyAuthUsername;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
    }

    public boolean isJobConsoleLogEnabled() {
        return this.jobConsoleLogEnabled;
    }

    public void setJobConsoleLogEnabled(boolean jobConsoleLogEnabled) {
        this.jobConsoleLogEnabled = jobConsoleLogEnabled;
    }

    public boolean isScmLogEnabled() {
        return this.scmLogEnabled;
    }

    public void setScmLogEnabled(boolean scmLogEnabled) {
        this.scmLogEnabled = scmLogEnabled;
    }

    public String getMetricDataPrefix() {
        return this.metricDataPrefix;
    }

    public void setMetricDataPrefix(String metricDataPrefix) {
        this.metricDataPrefix = metricDataPrefix;
    }

    public String getUrl() {
        return this.url.getPlainText();
    }

    public void setUrl(Secret url) {
        this.url = url;
    }

    public String getSourceCategory() {
        return this.sourceCategory;
    }

    public void setSourceCategory(String sourceCategory) {
        this.sourceCategory = sourceCategory;
    }

    public boolean isKeepOldConfigData() {
        return this.keepOldConfigData;
    }

    public void setKeepOldConfigData(boolean keepOldConfigData) {
        this.keepOldConfigData = keepOldConfigData;
    }

    public boolean isHandlerStarted() {
        return this.isHandlerStarted;
    }

    public void setHandlerStarted(boolean handlerStarted) {
        this.isHandlerStarted = handlerStarted;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void startSumoJenkinsLogHandler() {
        Timer.get().schedule(PluginDescriptorImpl.getInstance()::registerHandler, 3L, TimeUnit.MINUTES);
    }

    public void registerHandler() {
        Handler[] handlers;
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof SumoLogHandler)) continue;
            return;
        }
        Logger.getLogger("").addHandler(SumoLogHandler.getInstance());
        this.isHandlerStarted = true;
    }

    private static class PluginConfigurationFromMain
    extends SlaveToMasterCallable<PluginConfiguration, IllegalStateException> {
        protected static final long serialVersionUID = 1L;

        private PluginConfigurationFromMain() {
        }

        public PluginConfiguration call() throws IllegalStateException {
            PluginDescriptorImpl pluginDescriptor = (PluginDescriptorImpl)Jenkins.get().getDescriptor(SumoBuildNotifier.class);
            assert (pluginDescriptor != null);
            return new PluginConfiguration(pluginDescriptor);
        }
    }
}

