/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import hudson.model.Node;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.plugins.casc.misc.ConfiguredWithCode;
import io.jenkins.plugins.casc.misc.JenkinsConfiguredWithCodeRule;
import io.jenkins.plugins.casc.misc.junit.jupiter.WithJenkinsConfiguredWithCode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@WithJenkinsConfiguredWithCode
class SSHLauncherCasCSupportTest {
    SSHLauncherCasCSupportTest() {
    }

    @Test
    @ConfiguredWithCode(value={"SSHCasCConfig.yml"})
    void shouldBeAbleToConfigureSSHSlaves(JenkinsConfiguredWithCodeRule j) {
        SSHLauncherCasCSupportTest.validateConfiguration(j);
    }

    @Test
    @ConfiguredWithCode(value={"SSHCasCConfigLegacy.yml"})
    void shouldBeAbleToConfigureLegacySSHSlaves(JenkinsConfiguredWithCodeRule j) {
        SSHLauncherCasCSupportTest.validateConfiguration(j);
    }

    private static void validateConfiguration(JenkinsConfiguredWithCodeRule j) {
        Node node = j.jenkins.getNode("this-ssh-agent");
        Assertions.assertNotNull((Object)node);
        SlaveComputer computer = (SlaveComputer)node.toComputer();
        Assertions.assertNotNull((Object)computer);
        SSHLauncher launcher = (SSHLauncher)computer.getLauncher();
        Assertions.assertNotNull((Object)launcher);
        Assertions.assertEquals((Object)"ssh-host", (Object)launcher.getHost());
        Assertions.assertEquals((int)2222, (int)launcher.getPort());
        Assertions.assertEquals((Object)"-DuberImportantParam=uberImportantValue", (Object)launcher.getJvmOptions());
    }
}

