/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.sonar.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.sonar.api.SonarComponentShow;

public abstract class SonarHttpRequester {
    private static final String SONAR_API_COMPONENT_SHOW = "/api/components/show?key=%s";
    private transient HttpClientContext httpClientContext;
    private transient CloseableHttpClient httpClient;
    private boolean logged = false;
    private String token;

    protected String getSonarApiComponentShow() {
        return SONAR_API_COMPONENT_SHOW;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged(boolean logged) {
        this.logged = logged;
    }

    private void loginApi(SonarInstance sonarInstance) {
        this.httpClientContext = HttpClientContext.create();
        if (sonarInstance.getToken() != null && StringUtils.isNotEmpty((String)sonarInstance.getToken().getPlainText())) {
            this.token = sonarInstance.getToken().getPlainText();
            this.httpClient = HttpClientBuilder.create().build();
        } else {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(sonarInstance.getUsername(), sonarInstance.getPass().getPlainText().toCharArray()));
            this.httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            this.httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            HttpPost loginHttpPost = new HttpPost(sonarInstance.getUrl() + this.getSonarApiLogin());
            ArrayList<NameValuePair> formData = new ArrayList<NameValuePair>();
            formData.add((NameValuePair)new BasicNameValuePair("login", sonarInstance.getUsername()));
            formData.add((NameValuePair)new BasicNameValuePair("password", sonarInstance.getPass().getPlainText()));
            formData.add((NameValuePair)new BasicNameValuePair("remember_me", "1"));
            loginHttpPost.setEntity((HttpEntity)this.createEntity(formData));
            loginHttpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.executePostRequest(this.httpClient, loginHttpPost);
        }
        this.logged = true;
    }

    protected abstract String getSonarApiLogin();

    private void executePostRequest(CloseableHttpClient client, HttpPost loginHttpPost) throws QGException {
        try {
            client.execute((ClassicHttpRequest)loginHttpPost, classicHttpResponse -> classicHttpResponse);
        }
        catch (IOException e) {
            throw new QGException("POST execution error", e);
        }
    }

    private UrlEncodedFormEntity createEntity(List<NameValuePair> nvps) throws QGException {
        return new UrlEncodedFormEntity(nvps);
    }

    private String executeGetRequest(CloseableHttpClient client, HttpGet request) throws QGException {
        if (StringUtils.isNotEmpty((String)this.token)) {
            String authHeader = "Basic " + Base64.getEncoder().encodeToString((this.token + ":").getBytes(StandardCharsets.UTF_8));
            request.addHeader("Authorization", (Object)authHeader);
        }
        try {
            Map responseMap = (Map)client.execute((ClassicHttpRequest)request, (HttpContext)this.httpClientContext, classicHttpResponse -> {
                HashMap<String, Object> retVal = new HashMap<String, Object>();
                retVal.put("statusCode", classicHttpResponse.getCode());
                retVal.put("content", EntityUtils.toString((HttpEntity)classicHttpResponse.getEntity()));
                return retVal;
            });
            Integer statusCode = (Integer)responseMap.get("statusCode");
            String returnResponse = responseMap.get("content").toString();
            if (statusCode != 200) {
                throw new QGException("Expected status 200, got: " + statusCode + ". Response: " + returnResponse);
            }
            return returnResponse;
        }
        catch (IOException e) {
            throw new QGException("GET execution error", e);
        }
    }

    String getAPITaskInfo(JobConfigData configData, SonarInstance sonarInstance) throws QGException {
        this.checkLogged(sonarInstance);
        String sonarProjectKey = this.getSonarApiTaskInfoParameter(configData, sonarInstance);
        String sonarProjectTaskInfoPath = this.getSonarApiTaskInfoUrl();
        String sonarHostUrl = sonarInstance.getUrl();
        String taskInfoUri = sonarHostUrl + sonarProjectTaskInfoPath.formatted(URLEncoder.encode(sonarProjectKey, StandardCharsets.UTF_8));
        HttpGet request = new HttpGet(taskInfoUri);
        return this.executeGetRequest(this.httpClient, request);
    }

    protected abstract String getSonarApiTaskInfoUrl();

    protected abstract String getSonarApiTaskInfoParameter(JobConfigData var1, SonarInstance var2);

    String getAPIInfo(JobConfigData configData, SonarInstance sonarInstance) throws QGException {
        this.checkLogged(sonarInstance);
        String sonarApiQualityGates = sonarInstance.getUrl() + this.getSonarApiQualityGatesStatusUrl().formatted(configData.getProjectKey());
        HttpGet request = new HttpGet(sonarApiQualityGates.formatted(configData.getProjectKey()));
        return this.executeGetRequest(this.httpClient, request);
    }

    protected abstract String getSonarApiQualityGatesStatusUrl();

    protected String getComponentId(JobConfigData configData, SonarInstance sonarInstance) {
        this.checkLogged(sonarInstance);
        String sonarApiQualityGates = sonarInstance.getUrl() + this.getSonarApiComponentShow().formatted(configData.getProjectKey());
        HttpGet request = new HttpGet(sonarApiQualityGates);
        String result = this.executeGetRequest(this.httpClient, request);
        Gson gson = new GsonBuilder().create();
        SonarComponentShow component = (SonarComponentShow)gson.fromJson(result, SonarComponentShow.class);
        return component.getComponent().getId();
    }

    private void checkLogged(SonarInstance sonarInstance) {
        if (!this.isLogged()) {
            this.loginApi(sonarInstance);
        }
    }
}

