/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SonarInstance
extends AbstractDescribableImpl<SonarInstance> {
    public static final String DEFAULT_URL = "http://localhost:9000";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASS = "admin";
    private String name;
    private String username;
    private String pass;
    private String url;
    private Secret secretPass;
    private Secret token;
    private int timeToWait;
    private int maxWaitTime;

    public SonarInstance() {
        this.name = "";
        this.url = "";
        this.username = "";
        this.pass = "";
    }

    @DataBoundConstructor
    public SonarInstance(String name, String url, String username, Secret secretPass, int timeToWait, int maxWaitTime) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.secretPass = secretPass;
        this.timeToWait = timeToWait;
        this.maxWaitTime = maxWaitTime;
    }

    public SonarInstance(String name, String url, String username, String pass) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.pass = pass;
    }

    public SonarInstance(String name, String url, Secret token, int timeToWait, int maxWaitTime) {
        this.name = name;
        this.url = url;
        this.token = token;
        this.timeToWait = timeToWait;
        this.maxWaitTime = maxWaitTime;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPass() {
        return this.secretPass;
    }

    @DataBoundSetter
    public void setPass(String pass) {
        this.secretPass = Secret.fromString((String)Util.fixEmptyAndTrim((String)pass));
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public int getTimeToWait() {
        return this.timeToWait;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @DataBoundSetter
    public void setTimeToWait(int timeToWait) {
        this.timeToWait = timeToWait;
    }

    @DataBoundSetter
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public Secret getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Secret.fromString((String)Util.fixEmptyAndTrim((String)token));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SonarInstance that = (SonarInstance)((Object)o);
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals((Object)that.token) : that.token != null) {
            return false;
        }
        if (this.pass != null ? !this.pass.equals(that.pass) : that.pass != null) {
            return false;
        }
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.pass != null ? this.pass.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SonarInstance{name='" + this.name + "', username='" + this.username + "', url='" + this.url + "', timeToWait='" + this.timeToWait + "', maxWaitTime=" + this.maxWaitTime + "}";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SonarInstance> {
    }
}

