/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.quality.gates.jenkins.plugin.BuildDecision;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.JobConfigurationService;
import org.quality.gates.jenkins.plugin.JobExecutionService;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.QGPublisherDescriptor;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.jenkins.plugin.enumeration.BuildStatusEnum;

public class QGPublisher
extends Recorder {
    private final JobConfigData jobConfigData;
    private final BuildDecision buildDecision;
    private final JobConfigurationService jobConfigurationService;
    private final JobExecutionService jobExecutionService;
    private SonarInstance sonarInstance;

    @DataBoundConstructor
    public QGPublisher(JobConfigData jobConfigData, SonarInstance sonarInstance) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = new BuildDecision(sonarInstance);
        this.jobExecutionService = new JobExecutionService();
        this.jobConfigurationService = new JobConfigurationService();
        this.sonarInstance = null;
    }

    public QGPublisher(JobConfigData jobConfigData, BuildDecision buildDecision, JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService, SonarInstance sonarInstance) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = buildDecision;
        this.jobConfigurationService = jobConfigurationService;
        this.jobExecutionService = jobExecutionService;
        this.sonarInstance = sonarInstance;
    }

    public JobConfigData getJobConfigData() {
        return this.jobConfigData;
    }

    public QGPublisherDescriptor getDescriptor() {
        return (QGPublisherDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.sonarInstance = this.buildDecision.chooseSonarInstance(this.jobExecutionService.getGlobalConfigData(), this.jobConfigData);
        if (this.sonarInstance == null) {
            listener.error("The Sonar Instance in the global configuration with name '%s' no longer exists.\n", new Object[]{this.jobConfigData.getSonarInstanceName()});
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        Result result = build.getResult();
        if (Result.SUCCESS != result) {
            listener.getLogger().println("Previous steps failed the build.\nResult is: " + String.valueOf(result));
            return false;
        }
        boolean buildHasPassed = false;
        try {
            JobConfigData checkedJobConfigData = this.jobConfigurationService.checkProjectKeyIfVariable(this.jobConfigData, build, listener);
            buildHasPassed = this.buildDecision.getStatus(this.sonarInstance, checkedJobConfigData, listener);
            if ("".equals(this.jobConfigData.getSonarInstanceName())) {
                listener.getLogger().println("WARNING: Quality Gates is running with default Sonar Instance.\nURL='http//localhost:9000'\nUsername='admin'\nPassword='admin'");
            }
            listener.getLogger().println("PostBuild-Step: Quality Gates plugin build passed: " + String.valueOf(buildHasPassed).toUpperCase());
            if (!buildHasPassed && BuildStatusEnum.UNSTABLE.equals((Object)checkedJobConfigData.getBuildStatus())) {
                build.setResult(Result.UNSTABLE);
                return true;
            }
        }
        catch (QGException e) {
            e.printStackTrace(listener.getLogger());
        }
        return buildHasPassed;
    }
}

