/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import hudson.Util;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.quality.gates.jenkins.plugin.SonarInstance;

public class GlobalConfigurationService {
    private List<SonarInstance> listOfGlobalConfigInstances;

    public void setListOfGlobalConfigInstances(List<SonarInstance> listOfGlobalConfigInstances) {
        this.listOfGlobalConfigInstances = listOfGlobalConfigInstances;
    }

    protected List<SonarInstance> instantiateGlobalConfigData(JSONObject json) {
        this.listOfGlobalConfigInstances = new ArrayList<SonarInstance>();
        JSON globalDataConfigs = (JSON)json.opt("sonarInstances");
        if (globalDataConfigs == null) {
            globalDataConfigs = new JSONArray();
        }
        this.initGlobalDataConfig(globalDataConfigs);
        return this.listOfGlobalConfigInstances;
    }

    protected void initGlobalDataConfig(JSON globalDataConfigs) {
        JSONArray array = this.getGlobalConfigsArray(globalDataConfigs);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonobject = array.getJSONObject(i);
            this.addGlobalConfigDataForSonarInstance(jsonobject);
        }
    }

    protected JSONArray getGlobalConfigsArray(JSON globalDataConfigs) {
        if (globalDataConfigs.isArray()) {
            return (JSONArray)JSONArray.class.cast(globalDataConfigs);
        }
        return this.createJsonArrayFromObject((JSONObject)globalDataConfigs);
    }

    protected JSONArray createJsonArrayFromObject(JSONObject globalDataConfigs) {
        JSONArray array = new JSONArray();
        array.add((Object)globalDataConfigs);
        return array;
    }

    protected void addGlobalConfigDataForSonarInstance(JSONObject globalConfigData) {
        String name = globalConfigData.optString("name");
        int timeToWait = globalConfigData.optInt("timeToWait");
        int maxWaitTime = globalConfigData.optInt("maxWaitTime");
        String url = globalConfigData.optString("url");
        if (!"".equals(name)) {
            String token = globalConfigData.optString("token");
            SonarInstance sonarInstance = StringUtils.isNotEmpty((String)token) ? new SonarInstance(name, url, Secret.fromString((String)Util.fixEmptyAndTrim((String)globalConfigData.optString("token"))), timeToWait, maxWaitTime) : new SonarInstance(name, url, globalConfigData.optString("account"), Secret.fromString((String)Util.fixEmptyAndTrim((String)globalConfigData.optString("password"))), timeToWait, maxWaitTime);
            if (!this.containsGlobalConfigWithName(name)) {
                this.listOfGlobalConfigInstances.add(sonarInstance);
            }
        }
    }

    protected boolean containsGlobalConfigWithName(String name) {
        for (SonarInstance globalConfigDataInstance : this.listOfGlobalConfigInstances) {
            if (!globalConfigDataInstance.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

