/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;

public class SyncUtil {
    private static final Logger LOGGER = Logger.getLogger(SyncUtil.class.getName());

    private SyncUtil() {
    }

    @Deprecated(since="380")
    public static void syncDirWithCfg(File scriptDirectory, ScriptlerConfiguration cfg) throws IOException {
        SyncUtil.syncDirWithCfg(scriptDirectory.toPath(), cfg);
    }

    public static void syncDirWithCfg(Path scriptDirectory, ScriptlerConfiguration cfg) throws IOException {
        List<Path> availablePhysicalScripts = SyncUtil.getAvailableScripts(scriptDirectory);
        for (Path file : availablePhysicalScripts) {
            String fileName = Objects.toString(file.getFileName(), null);
            if (cfg.getScriptById(fileName) != null) continue;
            ScriptInfo info = ScriptHelper.extractScriptInfo(ScriptHelper.readScriptFromFile(file));
            if (info != null) {
                List<Parameter> parameters = info.getParameters().stream().map(name -> new Parameter((String)name, null)).toList();
                cfg.addOrReplace(new Script(fileName, info.getName(), info.getComment(), false, parameters, false));
                continue;
            }
            cfg.addOrReplace(new Script(fileName, fileName, Messages.script_loaded_from_directory(), false, Collections.emptyList(), false));
        }
        HashSet<Script> unavailableScripts = new HashSet<Script>();
        for (Script s : cfg.getScripts()) {
            if (Files.exists(scriptDirectory.resolve(s.getScriptPath()), new LinkOption[0])) {
                s.setAvailable(true);
                continue;
            }
            Script unavailableScript = new Script(s.getId(), s.comment, false, false, false);
            unavailableScript.setParameters(s.getParameters());
            unavailableScripts.add(unavailableScript);
            LOGGER.info(() -> "for repo '" + String.valueOf(scriptDirectory) + "' " + String.valueOf(s) + " is not available!");
        }
        for (Script script : unavailableScripts) {
            cfg.addOrReplace(script);
        }
    }

    private static List<Path> getAvailableScripts(Path scriptDirectory) throws IOException {
        LOGGER.log(Level.FINE, "Listing files of {0}", scriptDirectory);
        try (Stream<Path> contents = Files.list(scriptDirectory);){
            List<Path> list = contents.filter(path -> path.endsWith(".groovy")).toList();
            return list;
        }
    }
}

