/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand.credentials;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.common.base.Strings;
import com.saucelabs.saucerest.SecurityUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.sauce_ondemand.BuildUtils;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SauceCredentials
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    protected final String username;
    protected final Secret apiKey;
    protected final String restEndpoint;
    protected ShortLivedConfig shortLivedConfig;
    public static final DomainRequirement DOMAIN_REQUIREMENT = new HostnamePortRequirement("saucelabs.com", 80);
    private static final String HMAC_KEY = "HMACMD5";
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH";

    @DataBoundConstructor
    public SauceCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @NonNull String username, @NonNull String apiKey, @NonNull String restEndpoint, @CheckForNull String description) {
        super(scope, id, description);
        this.apiKey = Secret.fromString((String)apiKey);
        this.username = username;
        this.restEndpoint = restEndpoint;
    }

    public ShortLivedConfig getShortLivedConfig() {
        return this.shortLivedConfig;
    }

    @DataBoundSetter
    public void setShortLivedConfig(ShortLivedConfig shortLivedConfig) {
        this.shortLivedConfig = shortLivedConfig;
    }

    public static SauceCredentials getCredentials(AbstractProject project) {
        if (project == null) {
            return null;
        }
        if (!(project instanceof BuildableItemWithBuildWrappers)) {
            return SauceCredentials.getCredentials((AbstractProject)project.getParent());
        }
        BuildableItemWithBuildWrappers p = (BuildableItemWithBuildWrappers)project;
        SauceOnDemandBuildWrapper bw = (SauceOnDemandBuildWrapper)p.getBuildWrappersList().get(SauceOnDemandBuildWrapper.class);
        if (bw == null) {
            return null;
        }
        String credentialsId = bw.getCredentialId();
        return SauceCredentials.getCredentialsById((Item)p, credentialsId);
    }

    public static SauceCredentials getCredentials(AbstractBuild build) {
        return SauceCredentials.getCredentials(build.getProject());
    }

    @NonNull
    public Secret getPassword() {
        if (this.getShortLivedConfig() != null) {
            try {
                Date d = new Date();
                Date expires = new Date(System.currentTimeMillis() + (long)this.getShortLivedConfig().getTime().intValue() * 1000L * 60L);
                String token = JWT.create().withIssuer("Jenkins/" + Jenkins.VERSION + " JenkinsSauceOnDemand/" + BuildUtils.getCurrentVersion()).withExpiresAt(expires).withIssuedAt(d).sign(Algorithm.HMAC256((String)this.apiKey.getPlainText()));
                return Secret.fromString((String)token);
            }
            catch (JWTCreationException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.getApiKey();
    }

    @NonNull
    public Secret getApiKey() {
        return this.apiKey;
    }

    @NonNull
    public String getRestEndpoint() {
        if (this.restEndpoint == null || this.restEndpoint.isEmpty()) {
            return "https://saucelabs.com/";
        }
        return this.restEndpoint;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "SauceCredentials{apiKey=" + this.apiKey + ", username='" + this.username + '\'' + ", restEndpoint='" + this.restEndpoint + '\'' + '}';
    }

    public static SauceCredentials getSauceCredentials(AbstractBuild build, SauceOnDemandBuildWrapper wrapper) {
        String credentialId = wrapper.getCredentialId();
        return SauceCredentials.getCredentialsById((Item)build.getProject(), credentialId);
    }

    public JenkinsSauceREST getSauceREST() {
        JenkinsSauceREST sauceREST = new JenkinsSauceREST(this.getUsername(), this.getPassword().getPlainText());
        sauceREST.setServer(this.restEndpoint);
        return sauceREST;
    }

    public static String migrateToCredentials(String username, String accessKey, String restEndpoint, String migratedFrom) throws InterruptedException, IOException {
        String credentialId;
        List<SauceCredentials> credentialsForDomain = SauceCredentials.all((Item)null);
        StandardUsernameCredentials existingCredentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull(credentialsForDomain, (CredentialsMatcher)CredentialsMatchers.withUsername((String)username));
        if (existingCredentials == null) {
            String createdCredentialId = UUID.randomUUID().toString();
            if (Strings.isNullOrEmpty((String)accessKey)) {
                throw new InterruptedException("Did not find password");
            }
            SauceCredentials credentialsToCreate = new SauceCredentials(CredentialsScope.GLOBAL, createdCredentialId, username, accessKey, restEndpoint, "migrated from " + migratedFrom);
            SystemCredentialsProvider credentialsProvider = SystemCredentialsProvider.getInstance();
            Map credentialsMap = credentialsProvider.getDomainCredentialsMap();
            Domain domain = Domain.global();
            if (credentialsMap.get(domain) == null) {
                credentialsMap.put(domain, Collections.EMPTY_LIST);
            }
            ((List)credentialsMap.get(domain)).add(credentialsToCreate);
            credentialsProvider.setDomainCredentialsMap(credentialsMap);
            credentialsProvider.save();
            credentialId = createdCredentialId;
        } else {
            credentialId = existingCredentials.getId();
        }
        return credentialId;
    }

    public static List<SauceCredentials> all(ItemGroup context) {
        return CredentialsProvider.lookupCredentials(SauceCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{DOMAIN_REQUIREMENT});
    }

    public static List<SauceCredentials> all(Item context) {
        return CredentialsProvider.lookupCredentials(SauceCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{DOMAIN_REQUIREMENT});
    }

    public static SauceCredentials getCredentialsById(Item context, String id) {
        return (SauceCredentials)CredentialsMatchers.firstOrNull(SauceCredentials.all(context), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    public String getHMAC(String jobId) {
        String key = this.username + ":" + this.getPassword().getPlainText();
        return SecurityUtils.hmacEncode((String)HMAC_KEY, (String)jobId, (String)key);
    }

    public static final class ShortLivedConfig
    extends AbstractDescribableImpl<ShortLivedConfig>
    implements Serializable {
        protected final Integer time;

        @DataBoundConstructor
        public ShortLivedConfig(Integer time) {
            this.time = time;
        }

        public Integer getTime() {
            return this.time;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ShortLivedConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Sauce Labs";
        }

        public FormValidation doCheckApiKey(@QueryParameter String value, @QueryParameter String username) {
            JenkinsSauceREST rest = new JenkinsSauceREST(username, value);
            if (rest.getUser().equals("")) {
                return FormValidation.error((String)"Bad username or Access key");
            }
            return FormValidation.ok();
        }

        public String getIconClassName() {
            return "icon-sauce-ondemand-credential";
        }
    }
}

