/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class TestIDDetails {
    public static final Pattern SESSION_ID_PATTERN = Pattern.compile("SauceOnDemandSessionID=([0-9a-fA-F]+)(?:.job-name=(.*))?");
    private final String jobId;
    private final String jobName;

    public TestIDDetails(String jobId, String jobName) {
        this.jobId = jobId;
        this.jobName = jobName;
    }

    public static TestIDDetails processString(@Nonnull String line) {
        Matcher m = SESSION_ID_PATTERN.matcher(line);
        if (!m.find()) {
            return null;
        }
        TestIDDetails details = new TestIDDetails(m.group(1), m.groupCount() >= 2 ? m.group(2) : null);
        return details;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestIDDetails that = (TestIDDetails)o;
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        return this.jobName != null ? this.jobName.equals(that.jobName) : that.jobName == null;
    }

    public int hashCode() {
        int result = this.jobId != null ? this.jobId.hashCode() : 0;
        result = 31 * result + (this.jobName != null ? this.jobName.hashCode() : 0);
        return result;
    }
}

