/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.Browser;
import com.saucelabs.ci.BrowserFactory;
import com.saucelabs.saucerest.SauceREST;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import java.util.Map;
import net.sf.json.JSONArray;
import org.kohsuke.stapler.DataBoundConstructor;

public class SauceParameterValue
extends ParameterValue {
    private static final BrowserFactory BROWSER_FACTORY = BrowserFactory.getInstance((SauceREST)new JenkinsSauceREST(null, null));
    private final String selectedBrowsersString;

    @DataBoundConstructor
    public SauceParameterValue(String name, String selectedBrowsers) {
        super(name);
        this.selectedBrowsersString = selectedBrowsers;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        SauceCredentials credentials = SauceCredentials.getCredentials(build);
        String userName = credentials.getUsername();
        String apiKey = credentials.getPassword().getPlainText();
        JSONArray selectedBrowsers = JSONArray.fromObject((Object)this.selectedBrowsersString);
        if (selectedBrowsers != null && !selectedBrowsers.isEmpty()) {
            if (selectedBrowsers.size() == 1) {
                Browser browserInstance = BROWSER_FACTORY.webDriverBrowserForKey(selectedBrowsers.getString(0));
                SauceEnvironmentUtil.outputEnvironmentVariablesForBrowser((Map<String, String>)env, browserInstance, userName, apiKey, true, false, null);
            } else {
                JSONArray browsersJSON = new JSONArray();
                for (int i = 0; i < selectedBrowsers.size(); ++i) {
                    String browser = selectedBrowsers.getString(i);
                    Browser browserInstance = BrowserFactory.getInstance().webDriverBrowserForKey(browser);
                    SauceEnvironmentUtil.browserAsJSON(browsersJSON, browserInstance, userName, apiKey);
                    SauceEnvironmentUtil.outputEnvironmentVariable((Map<String, String>)env, "SELENIUM_DRIVER", browserInstance.getUri(userName, apiKey), true, false, null);
                    SauceEnvironmentUtil.outputEnvironmentVariable((Map<String, String>)env, "SAUCE_ONDEMAND_BROWSERS", browsersJSON.toString(), true, false, null);
                }
            }
        }
    }
}

