/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.Browser;
import com.saucelabs.ci.BrowserFactory;
import com.saucelabs.saucerest.SauceREST;
import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceParameterValue;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SauceParameterDefinition
extends ParameterDefinition {
    private static final Logger logger = Logger.getLogger(SauceParameterDefinition.class.getName());
    private static final BrowserFactory BROWSER_FACTORY = BrowserFactory.getInstance((SauceREST)new JenkinsSauceREST(null, null));

    @DataBoundConstructor
    public SauceParameterDefinition() {
        super("Sauce Labs Browsers", "Select the browser(s) that should be used when tests are run with Sauce Labs");
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jo) {
        String selectedBrowsers = jo.getJSONArray("webDriverBrowsers").toString();
        return new SauceParameterValue(this.getName(), selectedBrowsers);
    }

    public ParameterValue createValue(StaplerRequest request) {
        throw new RuntimeException("Not supported");
    }

    public List<Browser> getWebDriverBrowsers() {
        try {
            return BROWSER_FACTORY.getWebDriverBrowsers();
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Error parsing JSON response", e);
            return Collections.emptyList();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Sauce Labs Browsers";
        }
    }
}

