/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceOnDemandReportPublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SauceOnDemandTestPublisher
extends Recorder
implements SimpleBuildStep {
    private DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers = new DescribableList(Saveable.NOOP);
    private JSONObject mixpanelJSON;

    @DataBoundConstructor
    public SauceOnDemandTestPublisher() {
    }

    public SauceOnDemandTestPublisher(DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this.testDataPublishers = testDataPublishers;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        TestResultAction report = (TestResultAction)run.getAction(TestResultAction.class);
        if (report != null) {
            ArrayList<TestResultAction.Data> data = new ArrayList<TestResultAction.Data>();
            if (this.testDataPublishers != null) {
                for (TestDataPublisher tdp : this.testDataPublishers) {
                    TestResultAction.Data d = tdp.contributeTestData(run, workspace, launcher, listener, report.getResult());
                    if (d == null) continue;
                    data.add(d);
                }
            }
            SauceOnDemandReportPublisher saucePublisher = this.createReportPublisher();
            TestResultAction.Data d = saucePublisher.contributeTestData(run, workspace, launcher, listener, report.getResult());
            data.add(d);
            report.setData(data);
            run.save();
        } else {
            SauceOnDemandReportPublisher saucePublisher = this.createReportPublisher();
            saucePublisher.contributeTestData(run, workspace, launcher, listener, null);
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.addTestDataPublishersToMavenModules(build, launcher, listener);
        this.addTestDataPublishersToBuildReport(build, launcher, listener);
        if (this.isDisableUsageStats()) {
            return true;
        }
        if (this.mixpanelJSON == null) {
            return true;
        }
        try {
            MessageBuilder messageBuilder = new MessageBuilder("5d9a83c5f58311b7b88622d0da5e7e9d");
            JSONObject sentEvent = messageBuilder.event(this.mixpanelJSON.getString("username"), "Jenkins JUNIT status", this.mixpanelJSON);
            ClientDelivery delivery = new ClientDelivery();
            delivery.addMessage(sentEvent);
            MixpanelAPI mixpanel = new MixpanelAPI();
            mixpanel.deliver(delivery);
        }
        catch (JSONException e) {
            listener.getLogger().println("Could not send junit status: " + e.getMessage());
        }
        return true;
    }

    private void addTestDataPublishersToMavenModules(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build instanceof MavenModuleSetBuild) {
            Map buildsMap = ((MavenModuleSetBuild)build).getModuleBuilds();
            for (List mavenBuild : buildsMap.values()) {
                MavenBuild lastBuild = this.getLastOrNullIfEmpty(mavenBuild);
                if (lastBuild == null) continue;
                this.addTestDataPublishersToBuildReport((AbstractBuild)lastBuild, launcher, listener);
            }
        }
    }

    private MavenBuild getLastOrNullIfEmpty(List<MavenBuild> builds) {
        if (builds.isEmpty()) {
            return null;
        }
        return builds.get(builds.size() - 1);
    }

    private void updateMixpanelJSON(JSONObject mixpanelJSON) {
        try {
            if (mixpanelJSON == null) {
                return;
            }
            if (this.mixpanelJSON == null) {
                this.mixpanelJSON = mixpanelJSON;
                return;
            }
            if (this.mixpanelJSON.getBoolean("failureMessageSent")) {
                return;
            }
            this.mixpanelJSON.put("failureMessageSent", mixpanelJSON.getBoolean("failureMessageSent"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private boolean isDisableUsageStats() {
        PluginImpl plugin = PluginImpl.get();
        if (plugin == null) {
            return true;
        }
        return plugin.isDisableUsageStats();
    }

    private void addTestDataPublishersToBuildReport(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        TestResultAction report = (TestResultAction)build.getAction(TestResultAction.class);
        if (report != null) {
            ArrayList<TestResultAction.Data> data = new ArrayList<TestResultAction.Data>();
            if (this.testDataPublishers != null) {
                for (TestDataPublisher tdp : this.testDataPublishers) {
                    TestResultAction.Data d = tdp.getTestData(build, launcher, listener, report.getResult());
                    if (d == null) continue;
                    data.add(d);
                }
            }
            SauceOnDemandReportPublisher saucePublisher = this.createReportPublisher();
            TestResultAction.Data d = saucePublisher.getTestData(build, launcher, listener, report.getResult());
            this.updateMixpanelJSON(saucePublisher.getMixpanelJSON());
            data.add(d);
            report.setData(data);
            build.save();
        } else {
            SauceOnDemandReportPublisher saucePublisher = this.createReportPublisher();
            saucePublisher.getTestData(build, launcher, listener, (TestResult)null);
            this.updateMixpanelJSON(saucePublisher.getMixpanelJSON());
        }
    }

    protected SauceOnDemandReportPublisher createReportPublisher() {
        return new SauceOnDemandReportPublisher();
    }

    public List<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public final void setTestDataPublishers(@Nonnull List<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = new DescribableList(Saveable.NOOP);
        this.testDataPublishers.addAll(testDataPublishers);
    }

    @Extension
    @Symbol(value={"saucePublisher"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Run Sauce Labs Test Publisher";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return !TestDataPublisher.all().isEmpty();
        }
    }
}

