/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sauce_ondemand.JenkinsBuildInformation;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.SauceOnDemandReportFactory;
import hudson.plugins.sauce_ondemand.TestIDDetails;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SauceOnDemandReportPublisher
extends TestDataPublisher {
    private static final Logger logger = Logger.getLogger(SauceOnDemandReportPublisher.class.getName());
    private static final String JOB_NAME_PATTERN = Pattern.quote("{0}");
    private String jobVisibility = "";
    private JSONObject mixpanelJSON;

    @DataBoundConstructor
    public SauceOnDemandReportPublisher() {
    }

    public void setMixpanelJSON(JSONObject mixpanelJSON) {
        this.mixpanelJSON = mixpanelJSON;
    }

    public JSONObject getMixpanelJSON() {
        return this.mixpanelJSON;
    }

    public String getJobVisibility() {
        return this.jobVisibility;
    }

    @DataBoundSetter
    public void setJobVisibility(String jobVisibility) {
        this.jobVisibility = jobVisibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResultAction.Data contributeTestData(Run<?, ?> run, @Nonnull FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) throws IOException, InterruptedException {
        try {
            listener.getLogger().println("Starting Sauce Labs test publisher");
            logger.finer("Sauce Labs test publisher was started in contributeTestData method");
            SauceOnDemandBuildAction buildAction = SauceOnDemandBuildAction.getSauceBuildAction(run);
            if (buildAction != null) {
                this.processBuildOutput(run, buildAction, testResult, listener);
                if (buildAction.hasSauceOnDemandResults()) {
                    SauceOnDemandReportFactory sauceOnDemandReportFactory = SauceOnDemandReportFactory.INSTANCE;
                    return sauceOnDemandReportFactory;
                }
                listener.getLogger().println("The Sauce OnDemand plugin is configured, but no session IDs were found in the test output.");
                TestResultAction.Data data = null;
                return data;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            listener.getLogger().println("Finished Sauce Labs test publisher");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SauceOnDemandReportFactory getTestData(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) {
        try {
            listener.getLogger().println("Starting Sauce Labs test publisher");
            logger.finer("Sauce Labs test publisher was started in getTestData method");
            SauceOnDemandBuildAction buildAction = SauceOnDemandBuildAction.getSauceBuildAction(build);
            if (buildAction != null) {
                this.processBuildOutput((Run)build, buildAction, testResult, (TaskListener)listener);
                if (buildAction.hasSauceOnDemandResults()) {
                    SauceOnDemandReportFactory sauceOnDemandReportFactory = SauceOnDemandReportFactory.INSTANCE;
                    return sauceOnDemandReportFactory;
                }
                listener.getLogger().println("The Sauce OnDemand plugin is configured, but no session IDs were found in the test output.");
                SauceOnDemandReportFactory sauceOnDemandReportFactory = null;
                return sauceOnDemandReportFactory;
            }
            SauceOnDemandReportFactory sauceOnDemandReportFactory = null;
            return sauceOnDemandReportFactory;
        }
        finally {
            listener.getLogger().println("Finished Sauce Labs test publisher");
        }
    }

    public static LinkedList<TestIDDetails> processSessionIds(Boolean isStdout, String ... logStrings) {
        LinkedList<TestIDDetails> onDemandTests = new LinkedList<TestIDDetails>();
        for (String logString : logStrings) {
            if (logString == null) continue;
            for (String text : logString.split("\n|\r")) {
                TestIDDetails details = TestIDDetails.processString(text);
                if (details == null) continue;
                logger.finer("Extracted ID " + details.getJobId() + " from line: " + text);
                onDemandTests.add(details);
            }
        }
        return onDemandTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private void processBuildOutput(Run build, SauceOnDemandBuildAction buildAction, TestResult testResult, TaskListener listener) {
        LinkedHashMap<String, JenkinsJobInformation> onDemandTests;
        JenkinsSauceREST sauceREST = this.getSauceREST(build);
        boolean failureMessageSent = false;
        HashMap<String, String> failedTestsMap = new HashMap<String, String>();
        String sauceBuildName = null;
        try {
            onDemandTests = SauceOnDemandBuildAction.retrieveJobIdsFromSauce(sauceREST, build);
        }
        catch (JSONException e) {
            logger.finer("Exception during retrieveJobIdsFromSauce:" + (Object)((Object)e));
            onDemandTests = new LinkedHashMap();
            logger.severe(e.getMessage());
        }
        LinkedList<TestIDDetails> testIds = new LinkedList<TestIDDetails>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(build.getLogInputStream()));
            logger.log(Level.FINE, "Parsing Sauce Session ids in stdout");
            while ((line = in.readLine()) != null) {
                testIds.addAll(SauceOnDemandReportPublisher.processSessionIds(true, line));
            }
        }
        catch (IOException e) {
            logger.finer("Exception while adding testIds ");
            logger.severe(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (testResult != null) {
            logger.log(Level.FINE, "Parsing Sauce Session ids in test results");
            logger.log(Level.FINER, "Test result pass/fail/skip: " + testResult.getPassCount() + "/" + testResult.getFailCount() + "/" + testResult.getSkipCount());
            for (SuiteResult sr : testResult.getSuites()) {
                testIds.addAll(SauceOnDemandReportPublisher.processSessionIds(false, sr.getStdout(), sr.getStderr()));
                for (CaseResult cr : sr.getCases()) {
                    if (!Objects.equals(cr.getStdout(), sr.getStdout())) {
                        testIds.addAll(SauceOnDemandReportPublisher.processSessionIds(false, cr.getStdout()));
                    }
                    if (Objects.equals(cr.getStderr(), sr.getStderr())) continue;
                    testIds.addAll(SauceOnDemandReportPublisher.processSessionIds(false, cr.getStderr()));
                }
            }
            if (!this.isDisableUsageStats()) {
                List failedTests = testResult.getFailedTests();
                for (CaseResult failedTest : failedTests) {
                    failedTestsMap.put(failedTest.getName(), failedTest.getErrorStackTrace().trim());
                }
            }
        }
        for (TestIDDetails details : testIds) {
            Boolean buildResult;
            JenkinsJobInformation jobInformation;
            if (onDemandTests.containsKey(details.getJobId())) {
                jobInformation = onDemandTests.get(details.getJobId());
            } else {
                jobInformation = new JenkinsJobInformation(details.getJobId(), "");
                try {
                    jobInformation.populateFromJson(new JSONObject(sauceREST.getJobInfo(details.getJobId())));
                    onDemandTests.put(jobInformation.getJobId(), jobInformation);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            Map updates = jobInformation.getChanges();
            if (jobInformation.getStatus() == null && (buildResult = this.hasTestPassed(testResult, jobInformation)) != null) {
                jobInformation.setStatus(buildResult != false ? "Passed" : "Failed");
                updates.put("passed", buildResult);
            }
            if (!jobInformation.hasJobName()) {
                jobInformation.setName(details.getJobName());
                updates.put("name", details.getJobName());
            }
            if (!jobInformation.hasBuild()) {
                jobInformation.setBuild(SauceEnvironmentUtil.getSanitizedBuildNumber(build));
                updates.put("build", jobInformation.getBuild());
            }
            if (!Strings.isNullOrEmpty((String)this.getJobVisibility())) {
                updates.put("public", this.getJobVisibility());
            }
            if (!this.isDisableUsageStats() && testResult != null && "Failed".equals(jobInformation.getStatus())) {
                HashMap<String, String> customData = new HashMap<String, String>();
                try {
                    JSONObject jobDetails = new JSONObject(sauceREST.getJobInfo(details.getJobId()));
                    if (jobDetails.has("custom-data") && !jobDetails.isNull("custom-data")) {
                        JSONObject existingCustomData = jobDetails.getJSONObject("custom-data");
                        Iterator customDataKeys = existingCustomData.keys();
                        while (customDataKeys.hasNext()) {
                            String customDataKey = (String)customDataKeys.next();
                            customData.put(customDataKey, existingCustomData.getString(customDataKey));
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    logger.fine("Error reading existing custom data: " + e.getMessage());
                }
                if (failedTestsMap.get(jobInformation.getName()) != null) {
                    customData.put("FAILURE_MESSAGE", (String)failedTestsMap.get(jobInformation.getName()));
                    failureMessageSent = true;
                }
                updates.put("custom-data", customData);
            }
            if (!updates.isEmpty()) {
                logger.fine("Performing Sauce REST update for " + jobInformation.getJobId());
                sauceREST.updateJobInfo(jobInformation.getJobId(), updates);
            } else {
                listener.getLogger().println("No updates for " + jobInformation.getJobId());
            }
            if (sauceBuildName != null) continue;
            sauceBuildName = jobInformation.getBuild();
        }
        if (!this.isDisableUsageStats()) {
            try {
                SauceCredentials credentials = SauceOnDemandBuildAction.getSauceBuildAction(build).getCredentials();
                CredentialsProvider.track((Run)build, (Credentials)credentials);
                String username = credentials.getUsername();
                JenkinsBuildInformation buildInformation = sauceBuildName != null ? buildAction.getSauceBuild(sauceBuildName) : buildAction.getSauceBuild();
                JSONObject props = new JSONObject();
                props.put("plugin", (Object)"jenkins");
                props.put("username", (Object)username);
                if (buildInformation == null) {
                    props.put("passed", JSONObject.NULL);
                } else {
                    props.put("passed", "success".equals(buildInformation.getStatus()));
                }
                props.put("failureMessageSent", failureMessageSent);
                this.setMixpanelJSON(props);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (onDemandTests.size() > 0) {
            buildAction.setJobs(new LinkedList<JenkinsJobInformation>(onDemandTests.values()));
            try {
                build.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.warning("Unable to save build: " + e.getMessage());
            }
        }
    }

    private boolean isDisableUsageStats() {
        PluginImpl plugin = PluginImpl.get();
        if (plugin == null) {
            return true;
        }
        return plugin.isDisableUsageStats();
    }

    protected JenkinsSauceREST getSauceREST(Run build) {
        return SauceOnDemandBuildAction.getSauceBuildAction(build).getCredentials().getSauceREST();
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean hasTestPassed(TestResult testResult, JenkinsJobInformation job) {
        if (testResult == null) {
            return null;
        }
        for (SuiteResult sr : testResult.getSuites()) {
            for (CaseResult cr : sr.getCases()) {
                if (job.getName() == null || job.getStatus() != null) continue;
                try {
                    Pattern jobNamePattern = Pattern.compile(MessageFormat.format(JOB_NAME_PATTERN, job.getName()));
                    Matcher matcher = jobNamePattern.matcher(cr.getFullName());
                    if (!job.getName().equals(cr.getFullName()) && !job.getName().contains(cr.getDisplayName()) && !matcher.find()) continue;
                    return cr.getStatus().equals((Object)CaseResult.Status.PASSED) || cr.getStatus().equals((Object)CaseResult.Status.FIXED);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error parsing line, attempting to continue", e);
                }
            }
        }
        logger.log(Level.FINER, "No matches with suites, attempt to use passed tests");
        for (CaseResult cr : testResult.getPassedTests()) {
            if (job.getName() == null || job.getStatus() != null) continue;
            try {
                Pattern jobNamePattern = Pattern.compile(MessageFormat.format(JOB_NAME_PATTERN, job.getName()));
                Matcher matcher = jobNamePattern.matcher(cr.getFullName());
                if (!job.getName().equals(cr.getFullName()) && !job.getName().contains(cr.getDisplayName()) && !matcher.find()) continue;
                return cr.getStatus().equals((Object)CaseResult.Status.PASSED) || cr.getStatus().equals((Object)CaseResult.Status.FIXED);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error parsing line, attempting to continue", e);
            }
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        public String getDisplayName() {
            return "Embed Sauce Labs reports";
        }

        public ListBoxModel doFillJobVisibilityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("- default -", "");
            items.add("Public", "public");
            items.add("Public Restricted", "public restricted");
            items.add("Private", "private");
            items.add("Team", "team");
            return items;
        }
    }
}

