/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import hudson.model.AbstractBuild;
import hudson.plugins.sauce_ondemand.SauceTestResultsById;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class SauceOnDemandReport
extends TestAction {
    private static final Logger logger = Logger.getLogger(SauceOnDemandReport.class.getName());
    public final CaseResult parent;
    private final List<String[]> sessionIds;
    @Deprecated
    private final String userName;
    @Deprecated
    private final String apiKey;

    public SauceOnDemandReport(CaseResult parent, List<String[]> ids) {
        this.userName = null;
        this.apiKey = null;
        this.parent = parent;
        this.sessionIds = ids;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.parent.getOwner();
    }

    public List<String> getIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String[] sessionId : this.sessionIds) {
            ids.add(sessionId[0]);
        }
        logger.fine("Retrieving Sauce job ids, found " + ((Object)ids).toString());
        return Collections.unmodifiableList(ids);
    }

    public String getId() {
        return this.getIDs().get(0);
    }

    public String getAuth() throws IOException {
        return new SauceTestResultsById(this.getId(), SauceCredentials.getCredentials(this.getBuild())).getAuth();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

