/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.sauceconnect.SauceConnectFourManager;
import com.saucelabs.jenkins.HudsonSauceManagerFactory;
import hudson.FilePath;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.sauce_ondemand.AbstractAction;
import hudson.plugins.sauce_ondemand.JenkinsBuildInformation;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SauceOnDemandProjectAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(SauceOnDemandProjectAction.class.getName());
    public transient Job<?, ?> job;
    @Deprecated
    private AbstractProject<?, ?> project;

    @Deprecated
    public SauceOnDemandProjectAction(AbstractProject<?, ?> project) {
        this((Job<?, ?>)project);
    }

    public SauceOnDemandProjectAction(Job<?, ?> job) {
        this.job = job;
        this.project = job instanceof AbstractProject ? (AbstractProject)job : null;
    }

    @Deprecated
    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean hasSauceOnDemandResults() {
        logger.fine("Checking if project has Sauce enabled");
        if (this.isSauceEnabled()) {
            logger.fine("Sauce is enabled, checking to see if project has Sauce results");
            List<SauceOnDemandBuildAction> sauceOnDemandBuildActions = this.getSauceBuildActions();
            if (sauceOnDemandBuildActions != null) {
                for (SauceOnDemandBuildAction action : sauceOnDemandBuildActions) {
                    if (!action.hasSauceOnDemandResults()) continue;
                    logger.fine("Found Sauce results");
                    return true;
                }
            }
        }
        logger.fine("Did not find Sauce results");
        return false;
    }

    @Deprecated
    private SauceOnDemandBuildWrapper getBuildWrapper() {
        return this.project != null ? SauceEnvironmentUtil.getBuildWrapper(this.project) : null;
    }

    public boolean isSauceEnabled() {
        return !this.getSauceBuildActions().isEmpty();
    }

    private List<SauceOnDemandBuildAction> getSauceBuildActions() {
        Run build = this.job.getLastBuild();
        if (build != null) {
            if (build instanceof MatrixBuild) {
                ArrayList<SauceOnDemandBuildAction> buildActions = new ArrayList<SauceOnDemandBuildAction>();
                MatrixBuild matrixBuild = (MatrixBuild)build;
                for (MatrixRun matrixRun : matrixBuild.getRuns()) {
                    SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)matrixRun.getAction(SauceOnDemandBuildAction.class);
                    if (buildAction == null) continue;
                    buildActions.add(buildAction);
                }
                return buildActions;
            }
            SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)build.getAction(SauceOnDemandBuildAction.class);
            if (buildAction == null) {
                logger.fine("No Sauce Build Action found for " + build.toString() + " adding a new one");
                return Collections.emptyList();
            }
            return Collections.singletonList(buildAction);
        }
        return Collections.emptyList();
    }

    @Override
    public List<JenkinsJobInformation> getJobsWithAuth() {
        logger.fine("Getting Sauce jobs with auth");
        return super.getJobsWithAuth();
    }

    @Override
    public List<JenkinsJobInformation> getJobs() {
        logger.fine("Getting Sauce jobs");
        List<SauceOnDemandBuildAction> sauceOnDemandBuildAction = this.getSauceBuildActions();
        if (sauceOnDemandBuildAction != null) {
            ArrayList<JenkinsJobInformation> allJobs = new ArrayList<JenkinsJobInformation>();
            for (SauceOnDemandBuildAction action : sauceOnDemandBuildAction) {
                allJobs.addAll(action.getJobs(true));
            }
            return allJobs;
        }
        logger.fine("No Sauce jobs found");
        return Collections.emptyList();
    }

    public JenkinsBuildInformation getBuild() {
        Iterator<SauceOnDemandBuildAction> iterator;
        logger.fine("Getting Sauce build");
        List<SauceOnDemandBuildAction> sauceOnDemandBuildActions = this.getSauceBuildActions();
        if (sauceOnDemandBuildActions != null && (iterator = sauceOnDemandBuildActions.iterator()).hasNext()) {
            SauceOnDemandBuildAction action = iterator.next();
            return action.getSauceBuild(true);
        }
        logger.fine("No Sauce build found");
        return null;
    }

    public Map<String, String> getAnalytics() {
        logger.fine("Getting Sauce analytics");
        SauceOnDemandBuildAction sauceBuildAction = this.getSauceBuildActions().get(0);
        return sauceBuildAction.getAnalytics();
    }

    @Override
    protected SauceCredentials getCredentials() {
        SauceOnDemandBuildAction sauceBuildAction = this.getSauceBuildActions().get(0);
        if (sauceBuildAction == null) {
            return null;
        }
        return sauceBuildAction.getCredentials();
    }

    public void doGenerateSupportZip(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InterruptedException {
        Job<?, ?> ac = this.job;
        Permission p = Project.CONFIGURE;
        ac.checkPermission(p);
        SauceConnectFourManager manager = HudsonSauceManagerFactory.getInstance().createSauceConnectFourManager();
        SauceOnDemandBuildWrapper sauceBuildWrapper = this.getBuildWrapper();
        Run build = this.job.getLastBuild();
        if (build == null) {
            rsp.setStatus(500);
            rsp.getOutputStream().print("Project has no builds");
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)baos);
        zipOutputStream.setLevel(0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_kk-mm");
        BuildSupportZipUtils.addFileToZipStream(zipOutputStream, "".getBytes("UTF-8"), "generated_" + df.format(Calendar.getInstance().getTime()));
        BuildSupportZipUtils.addFileToZipStream(zipOutputStream, FileUtils.readFileToByteArray((File)build.getLogFile()), "build.log");
        if (sauceBuildWrapper != null) {
            if (build instanceof AbstractBuild) {
                BuildSupportZipUtils.buildSauceConnectLog(zipOutputStream, manager, (AbstractBuild)build, sauceBuildWrapper);
            }
            BuildSupportZipUtils.buildWrapperConfigTxt(zipOutputStream, sauceBuildWrapper);
        }
        BuildSupportZipUtils.buildGlobalConfigTxt(zipOutputStream);
        zipOutputStream.finish();
        zipOutputStream.flush();
        rsp.setContentType("application/zip");
        rsp.addHeader("Content-Disposition", "attachment; filename=\"sauce_support.zip\"");
        rsp.addHeader("Content-Transfer-Encoding", "binary");
        rsp.getOutputStream().write(baos.toByteArray());
        rsp.getOutputStream().flush();
    }

    public static class BuildSupportZipUtils {
        public static void buildSauceConnectLog(ZipOutputStream zipOutputStream, SauceConnectFourManager manager, AbstractBuild build, SauceOnDemandBuildWrapper sauceBuildWrapper) throws IOException, InterruptedException {
            if (sauceBuildWrapper.isEnableSauceConnect()) {
                File sauceConnectLogFile = manager.getSauceConnectLogFile(sauceBuildWrapper.getOptions());
                if (sauceBuildWrapper.isLaunchSauceConnectOnSlave()) {
                    Node builtOn = build.getBuiltOn();
                    if (builtOn == null) {
                        return;
                    }
                    VirtualChannel channel = builtOn.getChannel();
                    if (channel == null) {
                        return;
                    }
                    FilePath fp = new FilePath(channel, sauceConnectLogFile.getPath());
                    BuildSupportZipUtils.addFileToZipStream(zipOutputStream, fp.readToString().getBytes("UTF-8"), "sc.log");
                } else if (sauceConnectLogFile != null) {
                    BuildSupportZipUtils.addFileToZipStream(zipOutputStream, FileUtils.readFileToByteArray((File)sauceConnectLogFile), "sc.log");
                }
            }
        }

        public static void buildGlobalConfigTxt(ZipOutputStream zipOutputStream) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
            StringBuilder pluginImplSB = new StringBuilder();
            for (Map.Entry entry : BeanUtils.describe((Object)((Object)PluginImpl.get())).entrySet()) {
                if (entry.getKey().equals("class") || entry.getKey().equals("descriptor")) continue;
                pluginImplSB.append(entry.getKey() + "=" + entry.getValue() + "\r\n");
            }
            pluginImplSB.append("version=" + PluginImpl.get().getWrapper().getVersion() + "\r\n");
            pluginImplSB.append("jenkinsVersion=" + Jenkins.VERSION + "\r\n");
            BuildSupportZipUtils.addFileToZipStream(zipOutputStream, pluginImplSB.toString().getBytes("UTF-8"), "global_sauce_config.txt");
        }

        public static void buildWrapperConfigTxt(ZipOutputStream zipOutputStream, SauceOnDemandBuildWrapper sauceBuildWrapper) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
            StringBuilder buildWrapperSB = new StringBuilder();
            for (Map.Entry entry : BeanUtils.describe((Object)sauceBuildWrapper).entrySet()) {
                if (entry.getKey().equals("class") || entry.getKey().equals("descriptor")) continue;
                buildWrapperSB.append(entry.getKey() + "=" + entry.getValue() + "\r\n");
            }
            BuildSupportZipUtils.addFileToZipStream(zipOutputStream, buildWrapperSB.toString().getBytes("UTF-8"), "build_wrapper_config.txt");
        }

        private static void addFileToZipStream(ZipOutputStream zipOutputStream, byte[] bytes, String filename) throws IOException {
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(filename);
            zipOutputStream.putNextEntry((ZipEntry)zipEntry);
            zipOutputStream.write(bytes);
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
        }
    }
}

