/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.base.Strings;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.saucelabs.ci.Browser;
import com.saucelabs.ci.sauceconnect.AbstractSauceTunnelManager;
import com.saucelabs.jenkins.HudsonSauceConnectFourManager;
import com.saucelabs.jenkins.HudsonSauceManagerFactory;
import com.saucelabs.saucerest.SauceREST;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.sauce_ondemand.Credentials;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.SeleniumInformation;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.remoting.Callable;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class SauceOnDemandBuildWrapper
extends BuildWrapper
implements Serializable {
    private static final Logger logger = Logger.getLogger(SauceOnDemandBuildWrapper.class.getName());
    public static final String SELENIUM_DRIVER = "SELENIUM_DRIVER";
    public static final String SAUCE_ONDEMAND_BROWSERS = "SAUCE_ONDEMAND_BROWSERS";
    public static final String SELENIUM_HOST = "SELENIUM_HOST";
    public static final String SELENIUM_PORT = "SELENIUM_PORT";
    public static final String SAUCE_USERNAME = "SAUCE_USERNAME";
    @Deprecated
    private static final String SAUCE_USER_NAME = "SAUCE_USER_NAME";
    @Deprecated
    private static final String SAUCE_API_KEY = "SAUCE_API_KEY";
    public static final String SAUCE_ACCESS_KEY = "SAUCE_ACCESS_KEY";
    public static final String SAUCE_REST_ENDPOINT = "SAUCE_REST_ENDPOINT";
    public static final String SELENIUM_DEVICE = "SELENIUM_DEVICE";
    public static final String SELENIUM_DEVICE_TYPE = "SELENIUM_DEVICE_TYPE";
    public static final String SELENIUM_DEVICE_ORIENTATION = "SELENIUM_DEVICE_ORIENTATION";
    public static final Pattern ENVIRONMENT_VARIABLE_PATTERN = Pattern.compile("[$|%][{]?([a-zA-Z_][a-zA-Z0-9_]+)[}]?");
    public static final String SELENIUM_BROWSER = "SELENIUM_BROWSER";
    public static final String SELENIUM_PLATFORM = "SELENIUM_PLATFORM";
    public static final String SELENIUM_VERSION = "SELENIUM_VERSION";
    @Deprecated
    public static final String JENKINS_BUILD_NUMBER = "JENKINS_BUILD_NUMBER";
    public static final String SAUCE_BUILD_NAME = "SAUCE_BUILD_NAME";
    public static final String USE_LATEST_SAUCE_CONNECT = "USE_LATEST_SAUCE_CONNECT";
    public static final String TUNNEL_IDENTIFIER = "TUNNEL_IDENTIFIER";
    private static final String SAUCE_NATIVE_APP = "SAUCE_NATIVE_APP";
    private static final String SAUCE_USE_CHROME = "SAUCE_USE_CHROME";
    private boolean useGeneratedTunnelIdentifier;
    private static final long serialVersionUID = 1L;
    @Deprecated
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient boolean sendUsageData;
    private String nativeAppPackage;
    private boolean useChromeForAndroid;
    private String sauceConnectPath;
    private boolean enableSauceConnect;
    private String seleniumHost;
    private String seleniumPort;
    @Deprecated
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Credentials credentials;
    private SeleniumInformation seleniumInformation;
    private List<String> webDriverBrowsers;
    private List<String> appiumBrowsers;
    private boolean useLatestVersion;
    private boolean useLatestSauceConnect;
    private boolean forceCleanup;
    private boolean launchSauceConnectOnSlave = true;
    private String options;
    private boolean verboseLogging = true;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private RunCondition condition;
    private String credentialId;

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        super.makeSensitiveBuildVariables(build, sensitiveVariables);
        sensitiveVariables.add(SAUCE_ACCESS_KEY);
        sensitiveVariables.add(SAUCE_API_KEY);
    }

    @DataBoundConstructor
    public SauceOnDemandBuildWrapper(boolean enableSauceConnect, RunCondition condition, String credentialId, SeleniumInformation seleniumInformation, String seleniumHost, String seleniumPort, String options, String sauceConnectPath, boolean launchSauceConnectOnSlave, boolean verboseLogging, boolean useLatestVersion, boolean useLatestSauceConnect, boolean forceCleanup, List<String> webDriverBrowsers, List<String> appiumBrowsers, String nativeAppPackage, boolean useGeneratedTunnelIdentifier) {
        this.seleniumInformation = seleniumInformation;
        this.enableSauceConnect = enableSauceConnect;
        this.seleniumHost = seleniumHost;
        this.seleniumPort = seleniumPort;
        this.options = options;
        this.webDriverBrowsers = webDriverBrowsers;
        this.appiumBrowsers = appiumBrowsers;
        if (seleniumInformation != null) {
            this.webDriverBrowsers = seleniumInformation.getWebDriverBrowsers();
            this.appiumBrowsers = seleniumInformation.getAppiumBrowsers();
        }
        this.launchSauceConnectOnSlave = launchSauceConnectOnSlave;
        this.verboseLogging = verboseLogging;
        this.useLatestVersion = useLatestVersion;
        this.useLatestSauceConnect = useLatestSauceConnect;
        this.forceCleanup = forceCleanup;
        this.condition = condition;
        this.sauceConnectPath = sauceConnectPath;
        this.nativeAppPackage = nativeAppPackage;
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
        this.credentialId = credentialId;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        SauceConnectHandler sauceConnectStarter;
        listener.getLogger().println("Starting pre-build for Sauce Labs plugin");
        logger.fine("Setting up Sauce Build Wrapper");
        SauceCredentials credentials = SauceCredentials.getSauceCredentials(build, this);
        CredentialsProvider.track((Run)build, (com.cloudbees.plugins.credentials.Credentials)credentials);
        PluginImpl p = PluginImpl.get();
        final String apiKey = credentials.getPassword().getPlainText();
        final String username = credentials.getUsername();
        final String restEndpoint = credentials.getRestEndpoint();
        final String tunnelIdentifier = SauceEnvironmentUtil.generateTunnelIdentifier(build.getProject().getName());
        if (this.isEnableSauceConnect()) {
            EnvVars env;
            boolean canRun = true;
            String workingDirectory = p != null ? p.getSauceConnectDirectory() : null;
            String maxRetries = p != null ? p.getSauceConnectMaxRetries() : null;
            String retryWaitTime = p != null ? p.getSauceConnectRetryWaitTime() : null;
            String resolvedOptions = this.getCommandLineOptions(build, listener);
            if (this.isUseGeneratedTunnelIdentifier()) {
                build.getBuildVariables().put(TUNNEL_IDENTIFIER, tunnelIdentifier);
                resolvedOptions = resolvedOptions + " --tunnel-identifier " + tunnelIdentifier;
            }
            build.getBuildVariables().put(SAUCE_REST_ENDPOINT, restEndpoint);
            resolvedOptions = resolvedOptions + " -x " + restEndpoint + "rest/v1";
            try {
                if (this.condition != null) {
                    canRun = this.condition.runPerform(build, listener);
                }
            }
            catch (Exception e) {
                listener.getLogger().println("Error checking Sauce Connect run condition");
                throw new IOException(e);
            }
            try {
                env = build.getEnvironment((TaskListener)listener);
            }
            catch (IOException e) {
                listener.getLogger().println("Error getting environment variables");
                throw e;
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Error getting environment variables");
                throw e;
            }
            if (canRun) {
                sauceConnectStarter = new SauceConnectHandler(this, env, listener, workingDirectory, this.useLatestSauceConnect, resolvedOptions, null, username, credentials.getApiKey().getPlainText(), maxRetries, retryWaitTime);
                if (this.launchSauceConnectOnSlave) {
                    listener.getLogger().println("Starting Sauce Connect on slave node using tunnel identifier: " + AbstractSauceTunnelManager.getTunnelIdentifier((String)resolvedOptions, (String)"default"));
                    Computer.currentComputer().getChannel().call((Callable)sauceConnectStarter);
                } else {
                    listener.getLogger().println("Starting Sauce Connect on master node using identifier: " + AbstractSauceTunnelManager.getTunnelIdentifier((String)resolvedOptions, (String)"default"));
                    sauceConnectStarter.call();
                }
            } else {
                listener.getLogger().println("Sauce Connect launch skipped due to run condition");
                sauceConnectStarter = null;
            }
        } else {
            sauceConnectStarter = null;
        }
        listener.getLogger().println("Finished pre-build for Sauce Labs plugin");
        if (!this.isDisableUsageStats()) {
            JenkinsSauceREST sauceREST = credentials.getSauceREST();
            try {
                logger.fine("Reporting usage stats");
                sauceREST.recordCI("jenkins", Jenkins.VERSION);
                try {
                    MessageBuilder messageBuilder = new MessageBuilder("5d9a83c5f58311b7b88622d0da5e7e9d");
                    String distinctId = username;
                    JSONObject props = new JSONObject();
                    props.put("plugin", (Object)"jenkins");
                    props.put("enableSauceConnect", this.enableSauceConnect);
                    props.put("verboseLogging", this.verboseLogging);
                    props.put("useGeneratedTunnelIdentifier", this.useGeneratedTunnelIdentifier);
                    props.put("launchSauceConnectOnSlave", this.launchSauceConnectOnSlave);
                    props.put("webDriverBrowsers", this.webDriverBrowsers);
                    props.put("appiumBrowsers", this.appiumBrowsers);
                    props.put("useLatestVersion", this.useLatestVersion);
                    props.put("useLatestSauceConnect", this.useLatestSauceConnect);
                    props.put("forceCleanup", this.forceCleanup);
                    props.put("restEndpoint", (Object)restEndpoint);
                    props.put("username", (Object)username);
                    JSONObject sentEvent = messageBuilder.event(distinctId, "Jenkins settings", props);
                    ClientDelivery delivery = new ClientDelivery();
                    delivery.addMessage(sentEvent);
                    MixpanelAPI mixpanel = new MixpanelAPI();
                    mixpanel.deliver(delivery);
                }
                catch (JSONException e) {
                    listener.getLogger().println((Object)e);
                }
            }
            catch (Exception e) {
                logger.finest("Error reporting in: " + e.getMessage());
            }
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                logger.fine("Creating Sauce environment variables");
                if (SauceOnDemandBuildWrapper.this.verboseLogging) {
                    listener.getLogger().println("The Sauce plugin has set the following environment variables:");
                }
                ArrayList<Browser> browsers = new ArrayList<Browser>();
                if (SauceOnDemandBuildWrapper.this.webDriverBrowsers != null) {
                    for (String webDriverBrowser : SauceOnDemandBuildWrapper.this.webDriverBrowsers) {
                        Browser browser = PluginImpl.BROWSER_FACTORY.webDriverBrowserForKey(webDriverBrowser);
                        if (browser != null && SauceOnDemandBuildWrapper.this.useLatestVersion) {
                            browser = new Browser(browser, true);
                        }
                        browsers.add(browser);
                    }
                }
                if (SauceOnDemandBuildWrapper.this.appiumBrowsers != null) {
                    for (String appiumBrowser : SauceOnDemandBuildWrapper.this.appiumBrowsers) {
                        browsers.add(PluginImpl.BROWSER_FACTORY.appiumBrowserForKey(appiumBrowser));
                    }
                }
                browsers.removeAll(Collections.singleton(null));
                SauceEnvironmentUtil.outputVariables(env, browsers, username, apiKey, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                Map buildVariables = build.getBuildVariables();
                if (buildVariables.containsKey(SauceOnDemandBuildWrapper.SELENIUM_BROWSER)) {
                    SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SELENIUM_BROWSER, (String)buildVariables.get(SauceOnDemandBuildWrapper.SELENIUM_BROWSER), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                }
                if (buildVariables.containsKey(SauceOnDemandBuildWrapper.SELENIUM_VERSION)) {
                    SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SELENIUM_VERSION, (String)buildVariables.get(SauceOnDemandBuildWrapper.SELENIUM_VERSION), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                }
                if (buildVariables.containsKey(SauceOnDemandBuildWrapper.SELENIUM_PLATFORM)) {
                    SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SELENIUM_PLATFORM, (String)buildVariables.get(SauceOnDemandBuildWrapper.SELENIUM_PLATFORM), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                }
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.JENKINS_BUILD_NUMBER, SauceEnvironmentUtil.getSanitizedBuildNumber((Run)build), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_BUILD_NAME, SauceEnvironmentUtil.getSanitizedBuildNumber((Run)build), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_USER_NAME, username, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_USERNAME, username, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_API_KEY, apiKey, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_ACCESS_KEY, apiKey, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_REST_ENDPOINT, restEndpoint, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SELENIUM_HOST, this.getHostName(), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                if (StringUtils.isNotBlank((String)SauceOnDemandBuildWrapper.this.getNativeAppPackage())) {
                    SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_NATIVE_APP, SauceOnDemandBuildWrapper.this.getNativeAppPackage(), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                }
                if (SauceOnDemandBuildWrapper.this.isEnableSauceConnect() && SauceOnDemandBuildWrapper.this.isUseGeneratedTunnelIdentifier()) {
                    SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.TUNNEL_IDENTIFIER, tunnelIdentifier, true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                }
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SAUCE_USE_CHROME, String.valueOf(SauceOnDemandBuildWrapper.this.isUseChromeForAndroid()), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
                DecimalFormat myFormatter = new DecimalFormat("####");
                SauceEnvironmentUtil.outputEnvironmentVariable(env, SauceOnDemandBuildWrapper.SELENIUM_PORT, myFormatter.format(sauceConnectStarter != null ? (long)sauceConnectStarter.port : (long)SauceOnDemandBuildWrapper.this.getPort(env)), true, SauceOnDemandBuildWrapper.this.verboseLogging, listener.getLogger());
            }

            private String getHostName() {
                if (StringUtils.isNotBlank((String)SauceOnDemandBuildWrapper.this.seleniumHost)) {
                    Matcher matcher = ENVIRONMENT_VARIABLE_PATTERN.matcher(SauceOnDemandBuildWrapper.this.seleniumHost);
                    if (matcher.matches()) {
                        String variableName = matcher.group(1);
                        return System.getenv(variableName);
                    }
                    return SauceOnDemandBuildWrapper.this.seleniumHost;
                }
                if (SauceOnDemandBuildWrapper.this.isEnableSauceConnect()) {
                    return SauceOnDemandBuildWrapper.getCurrentHostName();
                }
                return "ondemand.saucelabs.com";
            }

            public boolean tearDown(AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                SauceOnDemandBuildAction buildAction;
                listener2.getLogger().println("Starting post-build for Sauce Labs plugin");
                if (SauceOnDemandBuildWrapper.this.isEnableSauceConnect()) {
                    boolean shouldClose = true;
                    try {
                        if (SauceOnDemandBuildWrapper.this.condition != null) {
                            shouldClose = SauceOnDemandBuildWrapper.this.condition.runPerform(build2, listener2);
                        }
                    }
                    catch (Exception e) {
                        listener2.getLogger().println("Error checking Sauce Connect run condition");
                        throw new IOException(e);
                    }
                    if (shouldClose) {
                        listener2.getLogger().println("Shutting down Sauce Connect");
                        String resolvedOptions = SauceOnDemandBuildWrapper.this.getCommandLineOptions(build2, listener2);
                        if (SauceOnDemandBuildWrapper.this.isUseGeneratedTunnelIdentifier()) {
                            build2.getBuildVariables().put(SauceOnDemandBuildWrapper.TUNNEL_IDENTIFIER, tunnelIdentifier);
                            resolvedOptions = "--tunnel-identifier " + tunnelIdentifier + " " + resolvedOptions;
                        }
                        if (SauceOnDemandBuildWrapper.this.launchSauceConnectOnSlave) {
                            Computer.currentComputer().getChannel().call((Callable)new SauceConnectCloser(listener2, username, resolvedOptions));
                        } else {
                            SauceConnectCloser tunnelCloser = new SauceConnectCloser(listener2, username, resolvedOptions);
                            tunnelCloser.call();
                        }
                    }
                }
                if ((buildAction = (SauceOnDemandBuildAction)build2.getAction(SauceOnDemandBuildAction.class)) == null) {
                    buildAction = new SauceOnDemandBuildAction((Run)build2, SauceOnDemandBuildWrapper.this.credentialId);
                    build2.addAction((Action)buildAction);
                }
                if (SauceOnDemandBuildWrapper.this.forceCleanup) {
                    listener2.getLogger().println("Force cleanup enabled: Cleaning up jobs and tunnels instead of waiting for timeout");
                    buildAction = new SauceOnDemandBuildAction((Run)build2, SauceOnDemandBuildWrapper.this.credentialId);
                    buildAction.stopJobs();
                    SauceCredentials credentials = SauceCredentials.getSauceCredentials(build2, SauceOnDemandBuildWrapper.this);
                    JenkinsSauceREST sauceREST = credentials.getSauceREST();
                    if (SauceOnDemandBuildWrapper.this.isEnableSauceConnect() && SauceOnDemandBuildWrapper.this.isUseGeneratedTunnelIdentifier()) {
                        try {
                            String listResponse = sauceREST.getTunnels();
                            JSONArray tunnels = new JSONArray(listResponse);
                            for (int i = 0; i < tunnels.length(); ++i) {
                                String tunnel = tunnels.getString(i);
                                String jsonResponse = sauceREST.getTunnelInformation(tunnel);
                                JSONObject tunnelObj = new JSONObject(jsonResponse);
                                if (!tunnelObj.getString("tunnel_identifier").equals(tunnelIdentifier)) continue;
                                listener2.getLogger().println("Closing tunnel with uniquely generated ID: " + tunnelIdentifier);
                                sauceREST.deleteTunnel(tunnelObj.getString("id"));
                            }
                        }
                        catch (JSONException e) {
                            listener2.getLogger().println((Object)e);
                        }
                    } else {
                        listener2.getLogger().println("Tunnel may not have a unique ID, not force closing it");
                    }
                }
                HashMap<String, Object> customDataObj = new HashMap<String, Object>();
                if (!SauceOnDemandBuildWrapper.this.isDisableUsageStats()) {
                    listener2.getLogger().println("Updating the custom data field for jobs with Jenkins build info for analytics");
                    HashMap<String, Object> customData = new HashMap<String, Object>();
                    customData.put("JENKINS_BUILD_NAME", build2.getProject().getName());
                    customData.put("BUILD_NUMBER", build2.getNumber());
                    customData.put("GIT_COMMIT", build2.getEnvironment().get((Object)"GIT_COMMIT"));
                    customDataObj.put("custom-data", customData);
                    buildAction = new SauceOnDemandBuildAction((Run)build2, SauceOnDemandBuildWrapper.this.credentialId);
                    buildAction.updateJobs(customDataObj);
                }
                if (SauceOnDemandBuildWrapper.this.forceCleanup || !SauceOnDemandBuildWrapper.this.isDisableUsageStats()) {
                    List<JenkinsJobInformation> jobs = buildAction.getJobs();
                    int numJobs = jobs.size();
                    for (int waitCount = 0; waitCount < 5; ++waitCount) {
                        Thread.sleep(1000L);
                        buildAction = new SauceOnDemandBuildAction((Run)build2, SauceOnDemandBuildWrapper.this.credentialId);
                        jobs = buildAction.getJobs();
                        if (jobs.size() == numJobs) continue;
                        if (SauceOnDemandBuildWrapper.this.forceCleanup) {
                            buildAction.stopJobs();
                        }
                        if (!SauceOnDemandBuildWrapper.this.isDisableUsageStats()) {
                            buildAction.updateJobs(customDataObj);
                        }
                        numJobs = jobs.size();
                        waitCount = -1;
                    }
                    listener2.getLogger().println("Stopped/completed/updated " + numJobs + " jobs");
                }
                listener2.getLogger().println("Finished post-build for Sauce Labs plugin");
                return true;
            }
        };
    }

    public boolean isDisableUsageStats() {
        PluginImpl plugin = PluginImpl.get();
        if (plugin == null) {
            return true;
        }
        return plugin.isDisableUsageStats();
    }

    private String getCommandLineOptions(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        PluginImpl p = PluginImpl.get();
        ArrayList<String> resolvedOptions = new ArrayList<String>();
        resolvedOptions.add(this.getResolvedOptions(build, listener, p != null ? p.getSauceConnectOptions() : null));
        resolvedOptions.add(this.getResolvedOptions(build, listener, this.options));
        resolvedOptions.removeAll(Collections.singleton(""));
        return StringUtils.join(resolvedOptions, (String)" ");
    }

    private String getResolvedOptions(AbstractBuild build, BuildListener listener, String options) throws IOException, InterruptedException {
        if (options == null) {
            return "";
        }
        VariableResolver.ByMap variableResolver = new VariableResolver.ByMap((Map)build.getEnvironment((TaskListener)listener));
        return Util.replaceMacro((String)options, (VariableResolver)variableResolver);
    }

    private static String getCurrentHostName() {
        try {
            String hostName = Computer.currentComputer().getHostName();
            if (hostName != null) {
                return hostName;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to retrieve host name", e);
        }
        return "localhost";
    }

    private int getPort(Map<String, String> envVars) {
        if (StringUtils.isNotBlank((String)this.seleniumPort) && !this.seleniumPort.equals("0")) {
            Matcher matcher = ENVIRONMENT_VARIABLE_PATTERN.matcher(this.seleniumPort);
            if (matcher.matches()) {
                String variableName = matcher.group(1);
                String port = envVars.get(variableName);
                if (port == null) {
                    port = System.getenv(variableName);
                }
                if (port == null) {
                    port = "0";
                }
                return Integer.parseInt(port);
            }
            return Integer.parseInt(this.seleniumPort);
        }
        if (this.isEnableSauceConnect()) {
            if (this.isUseGeneratedTunnelIdentifier()) {
                try {
                    if (this.launchSauceConnectOnSlave) {
                        return (Integer)Computer.currentComputer().getChannel().call((Callable)new GetAvailablePort());
                    }
                    return new GetAvailablePort().call();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return 0;
            }
            return 4445;
        }
        return 4444;
    }

    public boolean isUseLatestVersion() {
        return this.useLatestVersion;
    }

    public boolean isForceCleanup() {
        return this.forceCleanup;
    }

    public String getSeleniumHost() {
        return this.seleniumHost;
    }

    public void setSeleniumHost(String seleniumHost) {
        this.seleniumHost = seleniumHost;
    }

    public String getSeleniumPort() {
        return this.seleniumPort;
    }

    public void setSeleniumPort(String seleniumPort) {
        this.seleniumPort = seleniumPort;
    }

    public SeleniumInformation getSeleniumInformation() {
        return this.seleniumInformation;
    }

    public void setSeleniumInformation(SeleniumInformation seleniumInformation) {
        this.seleniumInformation = seleniumInformation;
    }

    public boolean isEnableSauceConnect() {
        return this.enableSauceConnect;
    }

    public void setEnableSauceConnect(boolean enableSauceConnect) {
        this.enableSauceConnect = enableSauceConnect;
    }

    public List<String> getWebDriverBrowsers() {
        return this.webDriverBrowsers;
    }

    public void setWebDriverBrowsers(List<String> webDriverBrowsers) {
        this.webDriverBrowsers = webDriverBrowsers;
    }

    public List<String> getAppiumBrowsers() {
        return this.appiumBrowsers;
    }

    public void setAppiumBrowsers(List<String> appiumBrowsers) {
        this.appiumBrowsers = appiumBrowsers;
    }

    public boolean isLaunchSauceConnectOnSlave() {
        return this.launchSauceConnectOnSlave;
    }

    public void setLaunchSauceConnectOnSlave(boolean launchSauceConnectOnSlave) {
        this.launchSauceConnectOnSlave = launchSauceConnectOnSlave;
    }

    public boolean isUseLatestSauceConnect() {
        return this.useLatestSauceConnect;
    }

    public void setUseLatestSauceConnect(boolean useLatestSauceConnect) {
        this.useLatestSauceConnect = useLatestSauceConnect;
    }

    public boolean isUseGeneratedTunnelIdentifier() {
        return this.useGeneratedTunnelIdentifier;
    }

    public void setUseGeneratedTunnelIdentifier(boolean useGeneratedTunnelIdentifier) {
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public RunCondition getCondition() {
        return this.condition;
    }

    public String getSauceConnectPath() {
        return this.sauceConnectPath;
    }

    public void setSauceConnectPath(String sauceConnectPath) {
        this.sauceConnectPath = sauceConnectPath;
    }

    public boolean isUseChromeForAndroid() {
        return this.useChromeForAndroid;
    }

    public String getNativeAppPackage() {
        return this.nativeAppPackage;
    }

    public void setUseLatestVersion(boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
    }

    public void setForceCleanup(boolean forceCleanup) {
        this.forceCleanup = forceCleanup;
    }

    public void setNativeAppPackage(String nativeAppPackage) {
        this.nativeAppPackage = nativeAppPackage;
    }

    public void setUseChromeForAndroid(boolean useChromeForAndroid) {
        this.useChromeForAndroid = useChromeForAndroid;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public static AbstractSauceTunnelManager getSauceTunnelManager() throws ComponentLookupException {
        return HudsonSauceManagerFactory.getInstance().createSauceConnectFourManager();
    }

    protected boolean migrateCredentials(AbstractProject project) {
        if (Strings.isNullOrEmpty((String)this.credentialId)) {
            if (this.credentials != null) {
                try {
                    this.credentialId = SauceCredentials.migrateToCredentials(this.credentials.getUsername(), this.credentials.getApiKey(), this.credentials.getRestEndpoint(), project == null ? "Unknown" : project.getDisplayName());
                    return true;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.credentialId = SauceCredentials.migrateToCredentials(PluginImpl.get().getUsername(), PluginImpl.get().getApiKey().getPlainText(), PluginImpl.get().getRestEndpoint(), "Global");
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Extension
    public static final class ItemListenerImpl
    extends ItemListener {
        public void onLoaded() {
            Jenkins instance = Jenkins.getInstance();
            if (instance == null) {
                return;
            }
            for (BuildableItemWithBuildWrappers item : instance.getItems(BuildableItemWithBuildWrappers.class)) {
                AbstractProject p = item.asProject();
                for (SauceOnDemandBuildWrapper bw : ((BuildableItemWithBuildWrappers)p).getBuildWrappersList().getAll(SauceOnDemandBuildWrapper.class)) {
                    if (!bw.migrateCredentials(p)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        public String getDisplayName() {
            return "Sauce Labs Support";
        }

        public List<Browser> getAppiumBrowsers() {
            try {
                return PluginImpl.BROWSER_FACTORY.getAppiumBrowsers();
            }
            catch (JSONException e) {
                logger.log(Level.SEVERE, "Error parsing JSON response", e);
                return Collections.emptyList();
            }
        }

        public List<Browser> getWebDriverBrowsers() {
            try {
                return PluginImpl.BROWSER_FACTORY.getWebDriverBrowsers();
            }
            catch (JSONException e) {
                logger.log(Level.SEVERE, "Error parsing JSON response", e);
                return Collections.emptyList();
            }
        }

        public Map<String, List<Browser>> getWebDriverMap() {
            try {
                HashMap<String, List<Browser>> map = new HashMap<String, List<Browser>>();
                for (Browser browser : PluginImpl.BROWSER_FACTORY.getWebDriverBrowsers()) {
                    ArrayList<Browser> browsers = (ArrayList<Browser>)map.get(browser.getOs());
                    if (browsers == null) {
                        browsers = new ArrayList<Browser>();
                        map.put(browser.getOs(), browsers);
                    }
                    browsers.add(browser);
                }
                return map;
            }
            catch (JSONException e) {
                logger.log(Level.SEVERE, "Error parsing JSON response", e);
                return Collections.emptyMap();
            }
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(context));
        }
    }

    private static final class SauceConnectHandler
    extends MasterToSlaveCallable<SauceConnectHandler, AbstractSauceTunnelManager.SauceConnectException> {
        private final String options;
        private final String workingDirectory;
        private final boolean useLatestSauceConnect;
        private final String username;
        private final String key;
        private int maxRetries;
        private int retryWaitTime;
        private final BuildListener listener;
        private final boolean verboseLogging;
        private final String sauceConnectPath;
        private File sauceConnectJar;
        private int port;

        public SauceConnectHandler(SauceOnDemandBuildWrapper sauceOnDemandBuildWrapper, EnvVars env, BuildListener listener, String workingDirectory, boolean useLatestSauceConnect, String resolvedOptions, File sauceConnectJar, String username, String apiKey, String maxRetries, String retryWaitTime) {
            this.options = resolvedOptions;
            this.workingDirectory = workingDirectory;
            this.useLatestSauceConnect = useLatestSauceConnect;
            this.listener = listener;
            this.username = username;
            this.key = apiKey;
            this.port = sauceOnDemandBuildWrapper.getPort((Map)env);
            this.verboseLogging = sauceOnDemandBuildWrapper.isVerboseLogging();
            this.sauceConnectPath = sauceOnDemandBuildWrapper.getSauceConnectPath();
            this.sauceConnectJar = sauceConnectJar;
            try {
                this.maxRetries = Integer.parseInt(maxRetries);
            }
            catch (NumberFormatException e) {
                this.maxRetries = 0;
            }
            try {
                this.retryWaitTime = Integer.parseInt(retryWaitTime);
            }
            catch (NumberFormatException e) {
                this.retryWaitTime = this.maxRetries > 0 ? 5 : 0;
            }
        }

        public SauceConnectHandler call() throws AbstractSauceTunnelManager.SauceConnectException {
            AbstractSauceTunnelManager sauceTunnelManager;
            try {
                this.listener.getLogger().println("Launching Sauce Connect on " + SauceOnDemandBuildWrapper.getCurrentHostName());
                sauceTunnelManager = SauceOnDemandBuildWrapper.getSauceTunnelManager();
                if (sauceTunnelManager instanceof HudsonSauceConnectFourManager && this.workingDirectory != null) {
                    ((HudsonSauceConnectFourManager)sauceTunnelManager).setWorkingDirectory(this.workingDirectory);
                    ((HudsonSauceConnectFourManager)sauceTunnelManager).setUseLatestSauceConnect(this.useLatestSauceConnect);
                }
                sauceTunnelManager.setSauceRest((SauceREST)new JenkinsSauceREST(this.username, this.key));
                if (StringUtils.isBlank((String)this.username)) {
                    this.listener.getLogger().println("Username not set, not starting Sauce Connect");
                } else if (StringUtils.isBlank((String)this.key)) {
                    this.listener.getLogger().println("Access key not set, not starting Sauce Connect");
                }
            }
            catch (ComponentLookupException e) {
                throw new AbstractSauceTunnelManager.SauceConnectException((Exception)((Object)e));
            }
            if (this.maxRetries > 0) {
                int retryCount = 0;
                while (retryCount < this.maxRetries) {
                    try {
                        sauceTunnelManager.openConnection(this.username, this.key, this.port, this.sauceConnectJar, this.options, this.listener.getLogger(), Boolean.valueOf(this.verboseLogging), this.sauceConnectPath);
                        return this;
                    }
                    catch (AbstractSauceTunnelManager.SauceConnectDidNotStartException e) {
                        if (++retryCount >= this.maxRetries) {
                            throw new AbstractSauceTunnelManager.SauceConnectException((Exception)((Object)e));
                        }
                        this.listener.getLogger().println(String.format("Error launching Sauce Connect, trying %s time(s) more.", this.maxRetries - retryCount));
                        try {
                            Thread.sleep(1000L * (long)this.retryWaitTime);
                        }
                        catch (InterruptedException ie) {
                            throw new AbstractSauceTunnelManager.SauceConnectException((Exception)ie);
                        }
                    }
                }
            } else {
                sauceTunnelManager.openConnection(this.username, this.key, this.port, this.sauceConnectJar, this.options, this.listener.getLogger(), Boolean.valueOf(this.verboseLogging), this.sauceConnectPath);
            }
            return this;
        }
    }

    private static final class SauceConnectCloser
    extends MasterToSlaveCallable<SauceConnectCloser, AbstractSauceTunnelManager.SauceConnectException> {
        private final BuildListener listener;
        private final String username;
        private final String options;

        public SauceConnectCloser(BuildListener listener, String username, String options) {
            this.listener = listener;
            this.username = username;
            this.options = options;
        }

        public SauceConnectCloser call() throws AbstractSauceTunnelManager.SauceConnectException {
            try {
                if (!StringUtils.isBlank((String)this.username)) {
                    SauceOnDemandBuildWrapper.getSauceTunnelManager().closeTunnelsForPlan(this.username, this.options, this.listener.getLogger());
                }
            }
            catch (ComponentLookupException e) {
                throw new AbstractSauceTunnelManager.SauceConnectException((Exception)((Object)e));
            }
            return this;
        }
    }

    public static class GetAvailablePort
    extends MasterToSlaveCallable<Integer, RuntimeException> {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer call() {
            int foundPort = -1;
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(0);
                foundPort = socket.getLocalPort();
            }
            catch (IOException iOException) {
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return foundPort;
        }
    }
}

