/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.JobInformation;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.sauce_ondemand.AbstractAction;
import hudson.plugins.sauce_ondemand.JenkinsBuildInformation;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.SauceOnDemandProjectAction;
import hudson.plugins.sauce_ondemand.SauceTestResultsById;
import hudson.plugins.sauce_ondemand.StopJobThread;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SauceOnDemandBuildAction
extends AbstractAction
implements Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SauceOnDemandBuildAction.class.getName());
    public static final Pattern SESSION_ID_PATTERN = Pattern.compile("SauceOnDemandSessionID=([0-9a-fA-F]+)(?:.job-name=(.*))?");
    private transient Run build;
    private List<JenkinsJobInformation> jobInformation;
    private JenkinsBuildInformation buildInformation;
    @Deprecated
    private String accessKey;
    @Deprecated
    private String username;
    private String credentialsId;
    private String restEndpoint;

    @DataBoundConstructor
    public SauceOnDemandBuildAction(Run build, String credentialsId) {
        this.credentialsId = credentialsId;
        this.build = build;
    }

    public Run getBuild() {
        return this.build;
    }

    public boolean hasSauceOnDemandResults() {
        if (this.jobInformation == null) {
            return false;
        }
        return !this.getJobs().isEmpty();
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(boolean updateBuild) {
        if (updateBuild || this.buildInformation == null) {
            String buildNumber = SauceEnvironmentUtil.getSanitizedBuildNumber(this.build);
            this.buildInformation = this.getSauceBuild(buildNumber, updateBuild);
        }
        return this.buildInformation;
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild() {
        return this.getSauceBuild(false);
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(String sauceBuildName, boolean updateBuild) {
        if (updateBuild || this.buildInformation == null) {
            try {
                this.buildInformation = SauceOnDemandBuildAction.retrieveBuildFromSauce(this.getSauceREST(), sauceBuildName);
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Unable to retrieve Job data from Sauce Labs", e);
            }
        }
        return this.buildInformation;
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(String sauceBuildName) {
        return this.getSauceBuild(sauceBuildName, false);
    }

    public static JenkinsBuildInformation retrieveBuildFromSauce(JenkinsSauceREST sauceREST, String buildNumber) throws JSONException {
        JenkinsBuildInformation buildInformation = new JenkinsBuildInformation(buildNumber);
        logger.fine("Performing Sauce REST retrieve results for " + buildNumber);
        String jsonResponse = sauceREST.getBuild(buildNumber);
        if ("".equals(jsonResponse)) {
            logger.log(Level.WARNING, "Sauce REST API get build JSON Response was empty for " + buildNumber);
            return buildInformation;
        }
        JSONObject buildObj = new JSONObject(jsonResponse);
        buildInformation.populateFromJson(buildObj);
        return buildInformation;
    }

    @Exported(visibility=2)
    public List<JenkinsJobInformation> getJobs(boolean updateJobs) {
        if (updateJobs || this.jobInformation == null) {
            try {
                this.jobInformation = new ArrayList<JenkinsJobInformation>();
                this.jobInformation.addAll(SauceOnDemandBuildAction.retrieveJobIdsFromSauce(this.getSauceREST(), this.build, this.getCredentials()).values());
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Unable to retrieve Job data from Sauce Labs", e);
            }
        }
        SauceCredentials credentials = this.getCredentials();
        for (JobInformation jobInformation : this.jobInformation) {
            jobInformation.setHmac(credentials.getHMAC(jobInformation.getJobId()));
        }
        return this.jobInformation;
    }

    @Override
    @Exported(visibility=2)
    public List<JenkinsJobInformation> getJobs() {
        return this.getJobs(false);
    }

    public void stopJobs() {
        JenkinsSauceREST sauceREST = this.getSauceREST();
        List<JenkinsJobInformation> jobs = this.getJobs();
        ExecutorService executor = Executors.newFixedThreadPool(5);
        for (JobInformation jobInformation : jobs) {
            StopJobThread worker = new StopJobThread(sauceREST, jobInformation);
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }

    public void updateJobs(Map<String, Object> customDataObj) {
        JenkinsSauceREST sauceREST = this.getSauceREST();
        List<JenkinsJobInformation> jobs = this.getJobs();
        for (JobInformation jobInformation : jobs) {
            sauceREST.updateJobInfo(jobInformation.getJobId(), customDataObj);
        }
    }

    @Override
    protected SauceCredentials getCredentials() {
        if (this.credentialsId != null) {
            return SauceCredentials.getCredentialsById((Item)this.build.getParent(), this.credentialsId);
        }
        if (this.build instanceof AbstractBuild) {
            return SauceCredentials.getCredentials((AbstractBuild)this.build);
        }
        return null;
    }

    public static LinkedHashMap<String, JenkinsJobInformation> retrieveJobIdsFromSauce(JenkinsSauceREST sauceREST, Run build) throws JSONException {
        SauceCredentials credentials = SauceOnDemandBuildAction.getSauceBuildAction(build).getCredentials();
        return SauceOnDemandBuildAction.retrieveJobIdsFromSauce(sauceREST, build, credentials);
    }

    public static SauceOnDemandBuildAction getSauceBuildAction(Run build) {
        MavenModuleSetBuild mb;
        if (build == null) {
            return null;
        }
        SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)build.getAction(SauceOnDemandBuildAction.class);
        if (buildAction == null && build instanceof MavenBuild && (mb = ((MavenBuild)build).getParentBuild()) != null) {
            buildAction = (SauceOnDemandBuildAction)mb.getAction(SauceOnDemandBuildAction.class);
        }
        return buildAction;
    }

    public static LinkedHashMap<String, JenkinsJobInformation> retrieveJobIdsFromSauce(JenkinsSauceREST sauceREST, Run build, SauceCredentials credentials) throws JSONException {
        LinkedHashMap<String, JenkinsJobInformation> jobInformation = new LinkedHashMap<String, JenkinsJobInformation>();
        String buildNumber = SauceEnvironmentUtil.getSanitizedBuildNumber(build);
        logger.fine("Performing Sauce REST retrieve results for " + buildNumber);
        String jsonResponse = sauceREST.getBuildFullJobs(buildNumber, 5000);
        JSONObject job = new JSONObject(jsonResponse);
        JSONArray jobResults = job.getJSONArray("jobs");
        if (jobResults == null) {
            logger.log(Level.WARNING, "Unable to find job data for " + buildNumber);
        } else {
            for (int i = jobResults.length() - 1; i >= 0; --i) {
                JSONObject jobData = jobResults.getJSONObject(i);
                String jobId = jobData.getString("id");
                JenkinsJobInformation information = new JenkinsJobInformation(jobId, credentials.getHMAC(jobId));
                try {
                    information.populateFromJson(jobData);
                    jobInformation.put(information.getJobId(), information);
                    continue;
                }
                catch (JSONException e) {
                    logger.finer("Exception with populatefromJson:" + (Object)((Object)e));
                    logger.finer("jobData: " + jobData.toString());
                    throw e;
                }
            }
        }
        return jobInformation;
    }

    public Map<String, String> getAnalytics() {
        logger.fine("Getting Sauce analytics");
        HashMap<String, String> analytics = new HashMap<String, String>();
        JenkinsBuildInformation buildInformation = this.getSauceBuild(true);
        List<JenkinsJobInformation> allJobs = this.getJobs();
        long maxJobDuration = 0L;
        long totalJobDuration = 0L;
        for (JenkinsJobInformation job : allJobs) {
            long duration = job.getDuration();
            totalJobDuration += duration;
            if (duration <= maxJobDuration) continue;
            maxJobDuration = duration;
        }
        analytics.put("start", buildInformation.getStartDate());
        analytics.put("duration", buildInformation.getPrettyDuration());
        analytics.put("efficiency", buildInformation.getEfficiency(maxJobDuration, totalJobDuration));
        analytics.put("size", String.valueOf(buildInformation.getJobsFinished()));
        analytics.put("pass", buildInformation.getJobsPassRate());
        analytics.put("fail", buildInformation.getJobsFailRate());
        analytics.put("error", buildInformation.getJobsErrorRate());
        return analytics;
    }

    protected JenkinsSauceREST getSauceREST() {
        SauceCredentials creds = this.getCredentials();
        String username = creds != null ? creds.getUsername() : null;
        String accessKey = creds != null ? creds.getPassword().getPlainText() : null;
        String restEndpoint = creds != null ? creds.getRestEndpoint() : null;
        JenkinsSauceREST sauceREST = new JenkinsSauceREST(username, accessKey);
        if (restEndpoint != null) {
            sauceREST.setServer(restEndpoint);
        }
        return sauceREST;
    }

    public SauceTestResultsById getById(String id) {
        return new SauceTestResultsById(id, this.getCredentials());
    }

    @Override
    public void doJobReport(StaplerRequest req, StaplerResponse rsp) throws IOException {
        SauceTestResultsById byId = this.getById(req.getParameter("jobId"));
        try {
            req.getView((Object)byId, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    public void setJobs(List<JenkinsJobInformation> jobs) {
        this.jobInformation = jobs;
    }

    protected Object readResolve() {
        if (this.credentialsId == null && this.build.getParent() instanceof BuildableItemWithBuildWrappers) {
            BuildableItemWithBuildWrappers p = (BuildableItemWithBuildWrappers)this.build.getParent();
            SauceOnDemandBuildWrapper bw = (SauceOnDemandBuildWrapper)p.getBuildWrappersList().get(SauceOnDemandBuildWrapper.class);
            this.credentialsId = bw.getCredentialId();
        }
        return this;
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.build.getParent();
        if (!Util.filter((List)job.getActions(), SauceOnDemandProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new SauceOnDemandProjectAction(job));
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }
}

