/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.saucelabs.ci.BrowserFactory;
import com.saucelabs.saucerest.SauceREST;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class PluginImpl
extends Plugin
implements Describable<PluginImpl> {
    private static final Logger logger = Logger.getLogger(PluginImpl.class.getName());
    static final transient BrowserFactory BROWSER_FACTORY = BrowserFactory.getInstance((SauceREST)new JenkinsSauceREST(null, null));
    @Deprecated
    private transient String username;
    @Deprecated
    private transient Secret apiKey;
    @Deprecated
    private transient String restEndpoint;
    private boolean reuseSauceAuth;
    private String sauceConnectDirectory;
    private String sauceConnectOptions;
    private String sauceConnectMaxRetries;
    private String sauceConnectRetryWaitTime;
    @Deprecated
    private transient boolean disableStatusColumn;
    private String environmentVariablePrefix;
    private transient Boolean sendUsageData;
    private boolean disableUsageStats;
    private String credentialId;

    protected Object readResolve() {
        if (this.sendUsageData != null) {
            this.disableUsageStats = false;
        }
        return this;
    }

    public void start() throws Exception {
        IconSet.icons.addIcon(new Icon("icon-sauce-ondemand-credential icon-sm", "sauce-ondemand/images/16x16/sauce-logo-sm.png", "width: 16px; height: 16px;", IconType.PLUGIN));
        IconSet.icons.addIcon(new Icon("icon-sauce-ondemand-credential icon-md", "sauce-ondemand/images/24x24/sauce-logo-md.png", "width: 24px; height: 24px;", IconType.PLUGIN));
        IconSet.icons.addIcon(new Icon("icon-sauce-ondemand-credential icon-lg", "sauce-ondemand/images/32x32/sauce-logo-lg.png", "width: 32px; height: 32px;", IconType.PLUGIN));
        IconSet.icons.addIcon(new Icon("icon-sauce-ondemand-credential icon-xlg", "sauce-ondemand/images/48x48/sauce-logo-xlg.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        Items.XSTREAM.alias("hudson.plugins.sauce_ondemand.SoDBuildWrapper", SauceOnDemandBuildWrapper.class);
        Items.XSTREAM.alias("hudson.plugins.sauce__ondemand.SoDBuildWrapper", SauceOnDemandBuildWrapper.class);
        Items.XSTREAM.alias("hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper", SauceOnDemandBuildWrapper.class);
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.sauceConnectDirectory = formData.getString("sauceConnectDirectory");
        this.sauceConnectOptions = formData.getString("sauceConnectOptions");
        this.environmentVariablePrefix = formData.getString("environmentVariablePrefix");
        this.setDisableUsageStats(formData.getBoolean("disableUsageStats"));
        this.sauceConnectMaxRetries = formData.getString("sauceConnectMaxRetries");
        this.sauceConnectRetryWaitTime = formData.getString("sauceConnectRetryWaitTime");
        this.save();
    }

    public DescriptorImpl getDescriptor() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return (DescriptorImpl)j.getDescriptorOrDie(PluginImpl.class);
    }

    public static PluginImpl get() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return (PluginImpl)j.getPlugin(PluginImpl.class);
    }

    public String getSauceConnectDirectory() {
        return this.sauceConnectDirectory;
    }

    public void setSauceConnectDirectory(String sauceConnectDirectory) {
        this.sauceConnectDirectory = sauceConnectDirectory;
    }

    public String getEnvironmentVariablePrefix() {
        return this.environmentVariablePrefix;
    }

    public void setEnvironmentVariablePrefix(String environmentVariablePrefix) {
        this.environmentVariablePrefix = environmentVariablePrefix;
    }

    public String getSauceConnectMaxRetries() {
        return this.sauceConnectMaxRetries;
    }

    public void setSauceConnectMaxRetries(String sauceConnectMaxRetries) {
        this.sauceConnectMaxRetries = sauceConnectMaxRetries;
    }

    public String getSauceConnectRetryWaitTime() {
        return this.sauceConnectRetryWaitTime;
    }

    public void setSauceConnectRetryWaitTime(String sauceConnectRetryWaitTime) {
        this.sauceConnectRetryWaitTime = sauceConnectRetryWaitTime;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public Secret getApiKey() {
        return this.apiKey;
    }

    @Deprecated
    public String getRestEndpoint() {
        return this.restEndpoint;
    }

    public String getSauceConnectOptions() {
        return this.sauceConnectOptions;
    }

    public void setSauceConnectOptions(String sauceConnectOptions) {
        this.sauceConnectOptions = sauceConnectOptions;
    }

    public void setDisableUsageStats(boolean disableUsageStats) {
        this.disableUsageStats = disableUsageStats;
    }

    public boolean isDisableUsageStats() {
        return this.disableUsageStats;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<PluginImpl> {
        public String getDisplayName() {
            return "Sauce OnDemand";
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(context));
        }
    }
}

