/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.saucerest.SauceREST;
import hudson.ProxyConfiguration;
import hudson.plugins.sauce_ondemand.BuildUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import jenkins.model.Jenkins;

public class JenkinsSauceREST
extends SauceREST {
    private static final String BASE_URL = System.getenv("SAUCE_REST_ENDPOINT") != null ? System.getenv("SAUCE_REST_ENDPOINT") : System.getProperty("saucerest-java.base_url", "https://saucelabs.com/");
    private String server = BASE_URL;

    public JenkinsSauceREST(String username, String accessKey) {
        super(username, accessKey);
    }

    public String getRESTURL() {
        return this.buildURL("").toString();
    }

    public void setServer(String server) {
        if (server != null && !server.isEmpty()) {
            this.server = server;
        }
    }

    protected URL buildURL(String endpoint) {
        try {
            return new URL(new URL(this.server), "/rest/" + endpoint);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection hc = (HttpURLConnection)ProxyConfiguration.open((URL)url);
        return hc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JenkinsSauceREST)) {
            return super.equals(obj);
        }
        JenkinsSauceREST sauceobj = (JenkinsSauceREST)((Object)obj);
        if (!Objects.equals(sauceobj.username, this.username)) return false;
        if (!Objects.equals(sauceobj.accessKey, this.accessKey)) return false;
        if (!Objects.equals(sauceobj.server, this.server)) return false;
        if (!Objects.equals(BASE_URL, BASE_URL)) return false;
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    static {
        SauceREST.setExtraUserAgent((String)("Jenkins/" + Jenkins.VERSION + " JenkinsSauceOnDemand/" + BuildUtils.getCurrentVersion()));
    }
}

