/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.JobInformation;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JenkinsJobInformation
extends JobInformation {
    public JenkinsJobInformation(String jobId, String hmac) {
        super(jobId, hmac);
    }

    @Exported(visibility=2)
    public String getResult() {
        return Objects.equals("true", this.getStatus()) ? "OK" : "FAILURE";
    }

    @Exported(visibility=2)
    public String getLogUrl() {
        try {
            URIBuilder uriBuilder = new URIBuilder(super.getLogUrl());
            uriBuilder.addParameter("auth", this.getHmac());
            return uriBuilder.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return super.getLogUrl();
        }
    }

    @Exported(visibility=2)
    public String getVideoUrl() {
        try {
            URIBuilder uriBuilder = new URIBuilder(super.getVideoUrl().replace(".flv", ".mp4"));
            uriBuilder.addParameter("auth", this.getHmac());
            return uriBuilder.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return super.getVideoUrl();
        }
    }

    @Exported(visibility=2)
    public String getHmac() {
        return super.getHmac();
    }

    @Exported(visibility=2)
    public String getJobId() {
        return super.getJobId();
    }

    @Nullable
    @Exported(visibility=2)
    public String getStatus() {
        return super.getStatus();
    }

    @Nullable
    @Exported(visibility=2)
    public String getStatusColor() {
        String status = this.getStatus();
        if ("Passed".equals(status)) {
            return "green";
        }
        if ("Failed".equals(status)) {
            return "red";
        }
        if ("Error".equals(status)) {
            return "orange";
        }
        return status;
    }

    @Nullable
    @Exported(visibility=2)
    public String getName() {
        return super.getName();
    }

    @Exported(visibility=2)
    public String getBrowser() {
        String browser = super.getBrowser();
        browser = browser.replace("firefox", "Firefox");
        browser = browser.replace("iexplore", "Internet Explorer");
        browser = browser.replace("googlechrome", "Google Chrome");
        browser = browser.replace("safari", "Safari");
        browser = browser.replace("microsoftedge", "Microsoft Edge");
        browser = browser.replace("iphone", "iPhone");
        browser = browser.replace("android", "Android");
        return browser;
    }

    @Exported(visibility=2)
    public String getOs() {
        return super.getOs();
    }

    @Exported(visibility=2)
    public String getVersion() {
        return super.getVersion();
    }

    @Nullable
    @Exported(visibility=2)
    public String getFailureMessage() {
        return super.getFailureMessage();
    }

    @Exported(visibility=2)
    public boolean hasFailureMessage() {
        return super.hasFailureMessage();
    }

    @Exported(visibility=2)
    public String getPrettyDuration() {
        Duration duration = Duration.ofSeconds(super.getDuration());
        long hours = duration.toHours();
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        StringBuffer prettyDuration = new StringBuffer();
        if (hours > 0L) {
            prettyDuration.append(hours).append("hr ");
        }
        if (minutes > 0L) {
            prettyDuration.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            prettyDuration.append(seconds).append("s");
        }
        return prettyDuration.toString().trim();
    }
}

