/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.BuildInformation;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import javax.annotation.Nullable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JenkinsBuildInformation
extends BuildInformation {
    private static final DecimalFormat df = new DecimalFormat("#.#");

    public JenkinsBuildInformation(String buildId) {
        super(buildId);
    }

    @Exported(visibility=2)
    public String getBuildId() {
        return super.getBuildId();
    }

    @Nullable
    @Exported(visibility=2)
    public String getStatus() {
        return super.getStatus();
    }

    @Nullable
    @Exported(visibility=2)
    public String getName() {
        return super.getName();
    }

    @Exported(visibility=2)
    public String getStartDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
        return sdf.format(1000L * super.getStartTime());
    }

    @Exported(visibility=2)
    public long getDuration() {
        return super.getEndTime() - super.getStartTime();
    }

    @Exported(visibility=2)
    public long getStartTime() {
        return super.getStartTime();
    }

    @Exported(visibility=2)
    public long getEndTime() {
        return super.getEndTime();
    }

    @Exported(visibility=2)
    public String getPrettyDuration() {
        Duration duration = Duration.ofSeconds(this.getDuration());
        long hours = duration.toHours();
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        StringBuffer prettyDuration = new StringBuffer();
        if (hours > 0L) {
            prettyDuration.append(hours).append("hr ");
        }
        if (minutes > 0L) {
            prettyDuration.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            prettyDuration.append(seconds).append("s");
        }
        return prettyDuration.toString().trim();
    }

    @Exported(visibility=2)
    public String getEfficiency(long maxJobDuration, long totalJobDuration) {
        if (totalJobDuration == this.getDuration()) {
            return "0% (Sequential)";
        }
        float efficiency = (float)maxJobDuration * 100.0f / (float)this.getDuration();
        if (efficiency <= 90.0f) {
            return df.format(efficiency) + "% (Semi-parallel)";
        }
        return df.format(efficiency) + "% (Parallel)";
    }

    @Exported(visibility=2)
    public int getJobsFinished() {
        return super.getJobsFinished();
    }

    @Exported(visibility=2)
    public int getJobsPassed() {
        return super.getJobsPassed();
    }

    @Exported(visibility=2)
    public int getJobsFailed() {
        return super.getJobsFailed();
    }

    @Exported(visibility=2)
    public int getJobsErrored() {
        return super.getJobsErrored();
    }

    @Exported(visibility=2)
    public String getJobsPassRate() {
        return df.format((float)this.getJobsPassed() * 100.0f / (float)this.getJobsFinished());
    }

    @Exported(visibility=2)
    public String getJobsFailRate() {
        return df.format((float)this.getJobsFailed() * 100.0f / (float)this.getJobsFinished());
    }

    @Exported(visibility=2)
    public String getJobsErrorRate() {
        return df.format((float)this.getJobsErrored() * 100.0f / (float)this.getJobsFinished());
    }
}

