/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.Browser;
import com.saucelabs.ci.BrowserFactory;
import com.saucelabs.saucerest.SauceREST;
import hudson.matrix.Axis;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import java.util.List;
import java.util.Map;

public abstract class BrowserAxis
extends Axis {
    protected static final BrowserFactory BROWSER_FACTORY = BrowserFactory.getInstance((SauceREST)new JenkinsSauceREST(null, null));
    private transient MatrixProject project;

    public BrowserAxis(List<String> values) {
        super("SELENIUM_DRIVER", values);
    }

    public boolean hasValue(String key) {
        return this.getValues().contains(key);
    }

    public List<String> rebuild(MatrixBuild.MatrixBuildExecution context) {
        this.project = (MatrixProject)context.getProject();
        return super.rebuild(context);
    }

    public void addBuildVariable(String value, Map<String, String> map) {
        SauceCredentials creds = SauceCredentials.getCredentials((AbstractProject)this.project);
        String username = creds != null ? creds.getUsername() : map.get("SAUCE_USERNAME");
        String accessKey = creds != null ? creds.getPassword().getPlainText() : map.get("SAUCE_ACCESS_KEY");
        Browser browserInstance = this.getBrowserForKey(value);
        if (browserInstance != null) {
            SauceEnvironmentUtil.outputEnvironmentVariablesForBrowser(map, browserInstance, username, accessKey, false, null);
            StringBuilder builder = new StringBuilder();
            builder.append("-D").append(this.getName()).append('=').append(browserInstance.getUri(username, accessKey)).append("-D").append("SELENIUM_PLATFORM").append('=').append(browserInstance.getOs()).append("-D").append("SELENIUM_BROWSER").append('=').append(browserInstance.getBrowserName()).append("-D").append("SELENIUM_VERSION").append('=').append(browserInstance.getVersion());
            if (browserInstance.getDevice() != null) {
                builder.append("-D").append("SELENIUM_DEVICE").append('=').append(browserInstance.getDevice());
            }
            if (browserInstance.getDeviceType() != null) {
                builder.append("-D").append("SELENIUM_DEVICE_TYPE").append('=').append(browserInstance.getDeviceType());
            }
            if (browserInstance.getDeviceOrientation() != null) {
                builder.append("-D").append("SELENIUM_DEVICE_ORIENTATION").append('=').append(browserInstance.getDeviceOrientation());
            }
            map.put("arguments", "-D" + this.getName() + "=" + browserInstance.getUri(username, accessKey));
        }
    }

    protected abstract Browser getBrowserForKey(String var1);
}

