/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.jenkins.pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import com.saucelabs.jenkins.pipeline.ExpanderImpl;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SauceStep
extends AbstractStepImpl {
    private String credentialsId;

    @DataBoundConstructor
    public SauceStep(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getDisplayName() {
            return "Sauce";
        }

        public String getFunctionName() {
            return "sauce";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getProvidedContext() {
            return Collections.singleton(SauceCredentials.class);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(project));
        }
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient SauceStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        private BodyExecution body;

        public boolean start() throws Exception {
            Job job = this.run.getParent();
            if (!(job instanceof TopLevelItem)) {
                throw new Exception(job + " must be a top-level job");
            }
            SauceCredentials credentials = SauceCredentials.getCredentialsById((Item)job, this.step.getCredentialsId());
            if (credentials == null) {
                throw new Exception("no credentials provided");
            }
            CredentialsProvider.track(this.run, (Credentials)credentials);
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("SAUCE_USERNAME", credentials.getUsername());
            overrides.put("SAUCE_ACCESS_KEY", credentials.getPassword().getPlainText());
            overrides.put("SAUCE_REST_ENDPOINT", credentials.getRestEndpoint());
            overrides.put("JENKINS_BUILD_NUMBER", SauceEnvironmentUtil.getSanitizedBuildNumber(this.run));
            overrides.put("SAUCE_BUILD_NAME", SauceEnvironmentUtil.getSanitizedBuildNumber(this.run));
            SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)this.run.getAction(SauceOnDemandBuildAction.class);
            if (buildAction == null) {
                buildAction = new SauceOnDemandBuildAction(this.run, credentials.getId());
                this.run.addAction((Action)buildAction);
            }
            this.body = this.getContext().newBodyInvoker().withContext((Object)credentials).withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
        }
    }
}

