/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.jenkins.pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.inject.Inject;
import com.saucelabs.ci.sauceconnect.AbstractSauceTunnelManager;
import com.saucelabs.ci.sauceconnect.SauceConnectFourManager;
import com.saucelabs.jenkins.HudsonSauceManagerFactory;
import com.saucelabs.jenkins.pipeline.ExpanderImpl;
import com.saucelabs.saucerest.SauceREST;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.remoting.Callable;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SauceConnectStep
extends AbstractStepImpl {
    private Boolean verboseLogging = false;
    private Boolean useLatestSauceConnect = false;
    private Boolean useGeneratedTunnelIdentifier = false;
    private String options;
    private String sauceConnectPath;

    @DataBoundConstructor
    public SauceConnectStep() {
    }

    public SauceConnectStep(String options, Boolean verboseLogging, Boolean useLatestSauceConnect, Boolean useGeneratedTunnelIdentifier, String sauceConnectPath) {
        this.verboseLogging = verboseLogging;
        this.useLatestSauceConnect = useLatestSauceConnect;
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
        this.sauceConnectPath = Util.fixEmptyAndTrim((String)sauceConnectPath);
        this.options = StringUtils.trimToEmpty((String)options);
    }

    public String getOptions() {
        return this.options;
    }

    @DataBoundSetter
    public void setOptions(String options) {
        this.options = options;
    }

    public String getSauceConnectPath() {
        return this.sauceConnectPath;
    }

    @DataBoundSetter
    public void setSauceConnectPath(String sauceConnectPath) {
        this.sauceConnectPath = sauceConnectPath;
    }

    public Boolean getUseGeneratedTunnelIdentifier() {
        return this.useGeneratedTunnelIdentifier;
    }

    @DataBoundSetter
    public void setUseGeneratedTunnelIdentifier(Boolean useGeneratedTunnelIdentifier) {
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
    }

    public Boolean getUseLatestSauceConnect() {
        return this.useLatestSauceConnect;
    }

    @DataBoundSetter
    public void setUseLatestSauceConnect(Boolean useLatestSauceConnect) {
        this.useLatestSauceConnect = useLatestSauceConnect;
    }

    public Boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    @DataBoundSetter
    public void setVerboseLogging(Boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    @SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
    public static class SauceConnectStepExecution
    extends AbstractStepExecutionImpl {
        @Inject(optional=true)
        private transient SauceConnectStep step;
        @StepContextParameter
        private transient SauceCredentials sauceCredentials;
        @StepContextParameter
        private transient Computer computer;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;
        private BodyExecution body;

        public boolean start() throws Exception {
            Job job = this.run.getParent();
            if (!(job instanceof TopLevelItem)) {
                throw new Exception(job + " must be a top-level job");
            }
            Node node = this.computer.getNode();
            if (node == null) {
                throw new Exception("computer does not correspond to a live node");
            }
            int port = (Integer)this.computer.getChannel().call((Callable)new SauceOnDemandBuildWrapper.GetAvailablePort());
            ArrayList<String> optionsArray = new ArrayList<String>();
            optionsArray.add(PluginImpl.get().getSauceConnectOptions());
            optionsArray.add(this.step.getOptions());
            optionsArray.removeAll(Collections.singleton(""));
            String options = StringUtils.join(optionsArray, (String)" ");
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("SELENIUM_PORT", String.valueOf(port));
            overrides.put("SELENIUM_HOST", "localhost");
            if (this.step.getUseGeneratedTunnelIdentifier().booleanValue()) {
                String tunnelIdentifier = SauceEnvironmentUtil.generateTunnelIdentifier(job.getName());
                overrides.put("TUNNEL_IDENTIFIER", tunnelIdentifier);
                options = options + " --tunnel-identifier " + tunnelIdentifier;
            }
            if (System.getenv("SAUCE_REST_ENDPOINT") != null && !"".equals(System.getenv("SAUCE_REST_ENDPOINT"))) {
                options = options + " -x " + System.getenv("SAUCE_REST_ENDPOINT") + "/rest/v1";
            }
            this.listener.getLogger().println("Starting sauce connect");
            SauceStartConnectHandler handler = new SauceStartConnectHandler(this.sauceCredentials, port, options, this.listener, this.step.getVerboseLogging(), this.step.getSauceConnectPath(), this.step.getUseLatestSauceConnect());
            this.computer.getChannel().call((Callable)handler);
            this.body = this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides))).withCallback((BodyExecutionCallback)new Callback(this.sauceCredentials, options)).withDisplayName(null).start();
            return false;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
        }

        public static SauceConnectFourManager getSauceTunnelManager() {
            return HudsonSauceManagerFactory.getInstance().createSauceConnectFourManager();
        }

        private static final class Callback
        extends BodyExecutionCallback.TailCall {
            private final String options;
            private final SauceCredentials sauceCredentials;

            Callback(SauceCredentials sauceCredentials, String options) {
                this.sauceCredentials = sauceCredentials;
                this.options = options;
            }

            protected void finished(StepContext context) throws Exception {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                Computer computer = (Computer)context.get(Computer.class);
                SauceStopConnectHandler stopConnectHandler = new SauceStopConnectHandler(this.sauceCredentials, this.options, listener);
                computer.getChannel().call((Callable)stopConnectHandler);
            }
        }
    }

    private static final class SauceStopConnectHandler
    extends MasterToSlaveCallable<Void, AbstractSauceTunnelManager.SauceConnectException> {
        private final SauceCredentials sauceCredentials;
        private final String options;
        private final TaskListener listener;

        SauceStopConnectHandler(SauceCredentials sauceCredentials, String options, TaskListener listener) {
            this.sauceCredentials = sauceCredentials;
            this.options = options;
            this.listener = listener;
        }

        public Void call() throws AbstractSauceTunnelManager.SauceConnectException {
            SauceConnectFourManager sauceTunnelManager = SauceConnectStepExecution.getSauceTunnelManager();
            sauceTunnelManager.setSauceRest((SauceREST)this.sauceCredentials.getSauceREST());
            sauceTunnelManager.closeTunnelsForPlan(this.sauceCredentials.getUsername(), this.options, this.listener.getLogger());
            return null;
        }
    }

    private static final class SauceStartConnectHandler
    extends MasterToSlaveCallable<Void, AbstractSauceTunnelManager.SauceConnectException> {
        private final SauceCredentials sauceCredentials;
        private final int port;
        private final String options;
        private final TaskListener listener;
        private final Boolean verboseLogging;
        private final String sauceConnectPath;
        private final Boolean useLatestSauceConnect;

        SauceStartConnectHandler(SauceCredentials sauceCredentials, int port, String options, TaskListener listener, Boolean verboseLogging, String sauceConnectPath, Boolean useLatestSauceConnect) {
            this.sauceCredentials = sauceCredentials;
            this.port = port;
            this.options = options;
            this.listener = listener;
            this.verboseLogging = verboseLogging;
            this.sauceConnectPath = sauceConnectPath;
            this.useLatestSauceConnect = useLatestSauceConnect;
        }

        public Void call() throws AbstractSauceTunnelManager.SauceConnectException {
            SauceConnectFourManager sauceTunnelManager = SauceConnectStepExecution.getSauceTunnelManager();
            sauceTunnelManager.setSauceRest((SauceREST)this.sauceCredentials.getSauceREST());
            sauceTunnelManager.setUseLatestSauceConnect(this.useLatestSauceConnect.booleanValue());
            sauceTunnelManager.openConnection(this.sauceCredentials.getUsername(), this.sauceCredentials.getApiKey().getPlainText(), this.port, null, this.options, this.listener.getLogger(), this.verboseLogging, this.sauceConnectPath);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(SauceConnectStepExecution.class);
        }

        public String getDisplayName() {
            return "Sauce Connect";
        }

        public String getFunctionName() {
            return "sauceconnect";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(project));
        }
    }
}

