/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import hudson.Functions;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.s3.S3ArtifactsAction;
import java.util.List;

public class S3ArtifactsProjectAction
implements Action {
    private final AbstractProject<?, ?> project;

    public S3ArtifactsProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    private Run getLastSuccessfulBuild() {
        return this.project.getLastSuccessfulBuild();
    }

    public S3ArtifactsAction getLatestDeployedArtifacts() {
        if (Functions.isArtifactsPermissionEnabled() && !this.project.hasPermission(Run.ARTIFACTS)) {
            return null;
        }
        Run latestSuccessfulBuild = this.getLastSuccessfulBuild();
        if (latestSuccessfulBuild == null) {
            return null;
        }
        List actions = latestSuccessfulBuild.getActions(S3ArtifactsAction.class);
        if (actions == null || actions.size() == 0) {
            return null;
        }
        return (S3ArtifactsAction)actions.get(actions.size() - 1);
    }

    public int getLastSuccessfulNumber() {
        Run latestSuccessfulBuild = this.getLastSuccessfulBuild();
        if (latestSuccessfulBuild == null) {
            return 0;
        }
        return latestSuccessfulBuild.getNumber();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

