/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import hudson.Functions;
import hudson.model.Run;
import hudson.plugins.s3.ClientHelper;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.FingerprintRecord;
import hudson.plugins.s3.S3BucketPublisher;
import hudson.plugins.s3.S3Profile;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import jenkins.model.RunAction2;
import jenkins.security.FIPS140;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;

@ExportedBean
public class S3ArtifactsAction
implements RunAction2 {
    private final Run<?, ?> build;
    private final String profile;
    private final List<FingerprintRecord> artifacts;

    public S3ArtifactsAction(Run<?, ?> run, S3Profile profile, List<FingerprintRecord> artifacts) {
        this.build = run;
        this.profile = profile.getName();
        this.artifacts = artifacts;
        this.onLoad(run);
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getIconFileName() {
        return this.hasAccess() ? "fingerprint.png" : null;
    }

    public String getDisplayName() {
        return "S3 Artifacts";
    }

    public String getUrlName() {
        return this.hasAccess() ? "s3" : null;
    }

    private boolean hasAccess() {
        return !Functions.isArtifactsPermissionEnabled() || this.build.getParent().hasPermission(Run.ARTIFACTS);
    }

    public void onLoad(Run<?, ?> r) {
    }

    public void onAttached(Run r) {
    }

    public String getProfile() {
        return this.profile;
    }

    @Exported
    public List<FingerprintRecord> getArtifacts() {
        if (!this.hasAccess()) {
            return Collections.emptyList();
        }
        return this.artifacts;
    }

    public void doDownload(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ServletException {
        String restOfPath;
        if (Functions.isArtifactsPermissionEnabled()) {
            this.build.getParent().checkPermission(Run.ARTIFACTS);
        }
        if ((restOfPath = request.getRestOfPath()) == null) {
            return;
        }
        String artifact = restOfPath.substring(1);
        for (FingerprintRecord record : this.artifacts) {
            if (!record.getArtifact().getName().equals(artifact)) continue;
            S3Profile s3 = S3BucketPublisher.getProfile(this.profile);
            S3Client client = s3.getClient(record.getArtifact().getRegion());
            String url = this.getDownloadURL(client, s3, this.build, record);
            response.sendRedirect2(url);
            return;
        }
        response.sendError(404, "This artifact is not available");
    }

    private String getDownloadURL(S3Client client, S3Profile s3, Run run, FingerprintRecord record) {
        Destination dest = Destination.newFromRun(run, record.getArtifact());
        S3Presigner.Builder presignerBuilder = S3Presigner.builder().fipsEnabled(Boolean.valueOf(FIPS140.useCompliantAlgorithms())).s3Client(client).region(Region.of((String)record.getArtifact().getRegion()));
        if (ClientHelper.ENDPOINT_URI != null) {
            presignerBuilder.endpointOverride(ClientHelper.ENDPOINT_URI);
        }
        if (s3.isUsePathStyle()) {
            presignerBuilder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
        if (!s3.isUseRole()) {
            presignerBuilder.credentialsProvider(() -> AwsBasicCredentials.create((String)s3.getAccessKey(), (String)Secret.toString((Secret)s3.getSecretKey())));
        }
        try (S3Presigner presigner = presignerBuilder.build();){
            GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(dest.bucketName).key(dest.objectName);
            if (!record.isShowDirectlyInBrowser()) {
                String fileName = new File(dest.objectName).getName().trim();
                builder.responseContentDisposition(fileName);
            }
            GetObjectRequest getObjectRequest = (GetObjectRequest)builder.build();
            GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(s3.getSignedUrlExpirySeconds())).getObjectRequest(getObjectRequest).build();
            String string = presigner.presignGetObject(getObjectPresignRequest).url().toExternalForm();
            return string;
        }
    }
}

