/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.plugins.s3.S3Artifact;
import java.io.IOException;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class FingerprintRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean produced;
    private final String md5sum;
    private final S3Artifact artifact;
    private boolean keepForever;
    private boolean showDirectlyInBrowser;

    public FingerprintRecord(boolean produced, String bucket, String name, String region, String md5sum) {
        this.produced = produced;
        this.artifact = new S3Artifact(region, bucket, name);
        this.md5sum = md5sum;
        this.showDirectlyInBrowser = false;
        this.keepForever = false;
    }

    Fingerprint addRecord(Run<?, ?> run) throws IOException {
        FingerprintMap map = Jenkins.getInstance().getFingerprintMap();
        return map.getOrCreate(this.produced ? run : null, this.artifact.getName(), this.md5sum);
    }

    public boolean isKeepForever() {
        return this.keepForever;
    }

    public void setKeepForever(boolean keepForever) {
        this.keepForever = keepForever;
    }

    public boolean isShowDirectlyInBrowser() {
        return this.showDirectlyInBrowser;
    }

    public void setShowDirectlyInBrowser(boolean showDirectlyInBrowser) {
        this.showDirectlyInBrowser = showDirectlyInBrowser;
    }

    @Exported
    public String getName() {
        return this.artifact.getName();
    }

    @Exported
    public String getLink() {
        return this.artifact.getName().replace("\\", "%5C");
    }

    @Exported
    public String getFingerprint() {
        return this.md5sum;
    }

    @Exported
    public S3Artifact getArtifact() {
        return this.artifact;
    }
}

